#[doc = "Register `TCCR5B` reader"]
pub struct R(crate::R<TCCR5B_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR5B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR5B_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR5B_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR5B` writer"]
pub struct W(crate::W<TCCR5B_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR5B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR5B_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR5B_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Clock Select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CS5_A {
    #[doc = "0: No clock source (Timer/Counter stopped)"]
    NO_CLOCK_SOURCE_TIMER_COUNTER_STOPPED = 0,
    #[doc = "1: clk_IO/1 (no prescaling)"]
    CLK_IO_1_NO_PRESCALING = 1,
    #[doc = "2: clk_IO/8 (from prescaler)"]
    CLK_IO_8_FROM_PRESCALER = 2,
    #[doc = "3: clk_IO/64 (from prescaler)"]
    CLK_IO_64_FROM_PRESCALER = 3,
    #[doc = "4: clk_IO/256 (from prescaler)"]
    CLK_IO_256_FROM_PRESCALER = 4,
    #[doc = "5: clk_IO/1024 (from prescaler)"]
    CLK_IO_1024_FROM_PRESCALER = 5,
}
impl From<CS5_A> for u8 {
    #[inline(always)]
    fn from(variant: CS5_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CS5` reader - Clock Select"]
pub struct CS5_R(crate::FieldReader<u8, CS5_A>);
impl CS5_R {
    pub(crate) fn new(bits: u8) -> Self {
        CS5_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<CS5_A> {
        match self.bits {
            0 => Some(CS5_A::NO_CLOCK_SOURCE_TIMER_COUNTER_STOPPED),
            1 => Some(CS5_A::CLK_IO_1_NO_PRESCALING),
            2 => Some(CS5_A::CLK_IO_8_FROM_PRESCALER),
            3 => Some(CS5_A::CLK_IO_64_FROM_PRESCALER),
            4 => Some(CS5_A::CLK_IO_256_FROM_PRESCALER),
            5 => Some(CS5_A::CLK_IO_1024_FROM_PRESCALER),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `NO_CLOCK_SOURCE_TIMER_COUNTER_STOPPED`"]
    #[inline(always)]
    pub fn is_no_clock_source_timer_counter_stopped(&self) -> bool {
        **self == CS5_A::NO_CLOCK_SOURCE_TIMER_COUNTER_STOPPED
    }
    #[doc = "Checks if the value of the field is `CLK_IO_1_NO_PRESCALING`"]
    #[inline(always)]
    pub fn is_clk_io_1_no_prescaling(&self) -> bool {
        **self == CS5_A::CLK_IO_1_NO_PRESCALING
    }
    #[doc = "Checks if the value of the field is `CLK_IO_8_FROM_PRESCALER`"]
    #[inline(always)]
    pub fn is_clk_io_8_from_prescaler(&self) -> bool {
        **self == CS5_A::CLK_IO_8_FROM_PRESCALER
    }
    #[doc = "Checks if the value of the field is `CLK_IO_64_FROM_PRESCALER`"]
    #[inline(always)]
    pub fn is_clk_io_64_from_prescaler(&self) -> bool {
        **self == CS5_A::CLK_IO_64_FROM_PRESCALER
    }
    #[doc = "Checks if the value of the field is `CLK_IO_256_FROM_PRESCALER`"]
    #[inline(always)]
    pub fn is_clk_io_256_from_prescaler(&self) -> bool {
        **self == CS5_A::CLK_IO_256_FROM_PRESCALER
    }
    #[doc = "Checks if the value of the field is `CLK_IO_1024_FROM_PRESCALER`"]
    #[inline(always)]
    pub fn is_clk_io_1024_from_prescaler(&self) -> bool {
        **self == CS5_A::CLK_IO_1024_FROM_PRESCALER
    }
}
impl core::ops::Deref for CS5_R {
    type Target = crate::FieldReader<u8, CS5_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CS5` writer - Clock Select"]
pub struct CS5_W<'a> {
    w: &'a mut W,
}
impl<'a> CS5_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CS5_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No clock source (Timer/Counter stopped)"]
    #[inline(always)]
    pub fn no_clock_source_timer_counter_stopped(self) -> &'a mut W {
        self.variant(CS5_A::NO_CLOCK_SOURCE_TIMER_COUNTER_STOPPED)
    }
    #[doc = "clk_IO/1 (no prescaling)"]
    #[inline(always)]
    pub fn clk_io_1_no_prescaling(self) -> &'a mut W {
        self.variant(CS5_A::CLK_IO_1_NO_PRESCALING)
    }
    #[doc = "clk_IO/8 (from prescaler)"]
    #[inline(always)]
    pub fn clk_io_8_from_prescaler(self) -> &'a mut W {
        self.variant(CS5_A::CLK_IO_8_FROM_PRESCALER)
    }
    #[doc = "clk_IO/64 (from prescaler)"]
    #[inline(always)]
    pub fn clk_io_64_from_prescaler(self) -> &'a mut W {
        self.variant(CS5_A::CLK_IO_64_FROM_PRESCALER)
    }
    #[doc = "clk_IO/256 (from prescaler)"]
    #[inline(always)]
    pub fn clk_io_256_from_prescaler(self) -> &'a mut W {
        self.variant(CS5_A::CLK_IO_256_FROM_PRESCALER)
    }
    #[doc = "clk_IO/1024 (from prescaler)"]
    #[inline(always)]
    pub fn clk_io_1024_from_prescaler(self) -> &'a mut W {
        self.variant(CS5_A::CLK_IO_1024_FROM_PRESCALER)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Waveform Generation Mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum WGM5_A {
    #[doc = "0: Normal mode of operation"]
    NORMAL_MODE_OF_OPERATION = 0,
    #[doc = "1: PWM, phase correct, 8-bit"]
    PWM_PHASE_CORRECT_8_BIT = 1,
    #[doc = "2: PWM, phase correct, 9-bit"]
    PWM_PHASE_CORRECT_9_BIT = 2,
    #[doc = "3: PWM, phase correct, 10-bit"]
    PWM_PHASE_CORRECT_10_BIT = 3,
}
impl From<WGM5_A> for u8 {
    #[inline(always)]
    fn from(variant: WGM5_A) -> Self {
        variant as _
    }
}
#[doc = "Field `WGM5` reader - Waveform Generation Mode"]
pub struct WGM5_R(crate::FieldReader<u8, WGM5_A>);
impl WGM5_R {
    pub(crate) fn new(bits: u8) -> Self {
        WGM5_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> WGM5_A {
        match self.bits {
            0 => WGM5_A::NORMAL_MODE_OF_OPERATION,
            1 => WGM5_A::PWM_PHASE_CORRECT_8_BIT,
            2 => WGM5_A::PWM_PHASE_CORRECT_9_BIT,
            3 => WGM5_A::PWM_PHASE_CORRECT_10_BIT,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NORMAL_MODE_OF_OPERATION`"]
    #[inline(always)]
    pub fn is_normal_mode_of_operation(&self) -> bool {
        **self == WGM5_A::NORMAL_MODE_OF_OPERATION
    }
    #[doc = "Checks if the value of the field is `PWM_PHASE_CORRECT_8_BIT`"]
    #[inline(always)]
    pub fn is_pwm_phase_correct_8_bit(&self) -> bool {
        **self == WGM5_A::PWM_PHASE_CORRECT_8_BIT
    }
    #[doc = "Checks if the value of the field is `PWM_PHASE_CORRECT_9_BIT`"]
    #[inline(always)]
    pub fn is_pwm_phase_correct_9_bit(&self) -> bool {
        **self == WGM5_A::PWM_PHASE_CORRECT_9_BIT
    }
    #[doc = "Checks if the value of the field is `PWM_PHASE_CORRECT_10_BIT`"]
    #[inline(always)]
    pub fn is_pwm_phase_correct_10_bit(&self) -> bool {
        **self == WGM5_A::PWM_PHASE_CORRECT_10_BIT
    }
}
impl core::ops::Deref for WGM5_R {
    type Target = crate::FieldReader<u8, WGM5_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM5` writer - Waveform Generation Mode"]
pub struct WGM5_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM5_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: WGM5_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Normal mode of operation"]
    #[inline(always)]
    pub fn normal_mode_of_operation(self) -> &'a mut W {
        self.variant(WGM5_A::NORMAL_MODE_OF_OPERATION)
    }
    #[doc = "PWM, phase correct, 8-bit"]
    #[inline(always)]
    pub fn pwm_phase_correct_8_bit(self) -> &'a mut W {
        self.variant(WGM5_A::PWM_PHASE_CORRECT_8_BIT)
    }
    #[doc = "PWM, phase correct, 9-bit"]
    #[inline(always)]
    pub fn pwm_phase_correct_9_bit(self) -> &'a mut W {
        self.variant(WGM5_A::PWM_PHASE_CORRECT_9_BIT)
    }
    #[doc = "PWM, phase correct, 10-bit"]
    #[inline(always)]
    pub fn pwm_phase_correct_10_bit(self) -> &'a mut W {
        self.variant(WGM5_A::PWM_PHASE_CORRECT_10_BIT)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 3)) | ((value as u8 & 0x03) << 3);
        self.w
    }
}
#[doc = "Field `Res` reader - Reserved Bit"]
pub struct RES_R(crate::FieldReader<bool, bool>);
impl RES_R {
    pub(crate) fn new(bits: bool) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved Bit"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `ICES5` reader - Input Capture 5 Edge Select"]
pub struct ICES5_R(crate::FieldReader<bool, bool>);
impl ICES5_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICES5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICES5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICES5` writer - Input Capture 5 Edge Select"]
pub struct ICES5_W<'a> {
    w: &'a mut W,
}
impl<'a> ICES5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `ICNC5` reader - Input Capture 5 Noise Canceller"]
pub struct ICNC5_R(crate::FieldReader<bool, bool>);
impl ICNC5_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICNC5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICNC5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICNC5` writer - Input Capture 5 Noise Canceller"]
pub struct ICNC5_W<'a> {
    w: &'a mut W,
}
impl<'a> ICNC5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Clock Select"]
    #[inline(always)]
    pub fn cs5(&self) -> CS5_R {
        CS5_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bits 3:4 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm5(&self) -> WGM5_R {
        WGM5_R::new(((self.bits >> 3) & 0x03) as u8)
    }
    #[doc = "Bit 5 - Reserved Bit"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Input Capture 5 Edge Select"]
    #[inline(always)]
    pub fn ices5(&self) -> ICES5_R {
        ICES5_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Input Capture 5 Noise Canceller"]
    #[inline(always)]
    pub fn icnc5(&self) -> ICNC5_R {
        ICNC5_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - Clock Select"]
    #[inline(always)]
    pub fn cs5(&mut self) -> CS5_W {
        CS5_W { w: self }
    }
    #[doc = "Bits 3:4 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm5(&mut self) -> WGM5_W {
        WGM5_W { w: self }
    }
    #[doc = "Bit 5 - Reserved Bit"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Bit 6 - Input Capture 5 Edge Select"]
    #[inline(always)]
    pub fn ices5(&mut self) -> ICES5_W {
        ICES5_W { w: self }
    }
    #[doc = "Bit 7 - Input Capture 5 Noise Canceller"]
    #[inline(always)]
    pub fn icnc5(&mut self) -> ICNC5_W {
        ICNC5_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter5 Control Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr5b](index.html) module"]
pub struct TCCR5B_SPEC;
impl crate::RegisterSpec for TCCR5B_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr5b::R](R) reader structure"]
impl crate::Readable for TCCR5B_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr5b::W](W) writer structure"]
impl crate::Writable for TCCR5B_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR5B to value 0"]
impl crate::Resettable for TCCR5B_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
