#[doc = "Register `TCCR3A` reader"]
pub struct R(crate::R<TCCR3A_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR3A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR3A_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR3A_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR3A` writer"]
pub struct W(crate::W<TCCR3A_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR3A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR3A_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR3A_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Waveform Generation Mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum WGM3_A {
    #[doc = "0: Normal mode of operation"]
    NORMAL_MODE_OF_OPERATION = 0,
    #[doc = "1: PWM, phase correct, 8-bit"]
    PWM_PHASE_CORRECT_8_BIT = 1,
    #[doc = "2: PWM, phase correct, 9-bit"]
    PWM_PHASE_CORRECT_9_BIT = 2,
    #[doc = "3: PWM, phase correct, 10-bit"]
    PWM_PHASE_CORRECT_10_BIT = 3,
}
impl From<WGM3_A> for u8 {
    #[inline(always)]
    fn from(variant: WGM3_A) -> Self {
        variant as _
    }
}
#[doc = "Field `WGM3` reader - Waveform Generation Mode"]
pub struct WGM3_R(crate::FieldReader<u8, WGM3_A>);
impl WGM3_R {
    pub(crate) fn new(bits: u8) -> Self {
        WGM3_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> WGM3_A {
        match self.bits {
            0 => WGM3_A::NORMAL_MODE_OF_OPERATION,
            1 => WGM3_A::PWM_PHASE_CORRECT_8_BIT,
            2 => WGM3_A::PWM_PHASE_CORRECT_9_BIT,
            3 => WGM3_A::PWM_PHASE_CORRECT_10_BIT,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NORMAL_MODE_OF_OPERATION`"]
    #[inline(always)]
    pub fn is_normal_mode_of_operation(&self) -> bool {
        **self == WGM3_A::NORMAL_MODE_OF_OPERATION
    }
    #[doc = "Checks if the value of the field is `PWM_PHASE_CORRECT_8_BIT`"]
    #[inline(always)]
    pub fn is_pwm_phase_correct_8_bit(&self) -> bool {
        **self == WGM3_A::PWM_PHASE_CORRECT_8_BIT
    }
    #[doc = "Checks if the value of the field is `PWM_PHASE_CORRECT_9_BIT`"]
    #[inline(always)]
    pub fn is_pwm_phase_correct_9_bit(&self) -> bool {
        **self == WGM3_A::PWM_PHASE_CORRECT_9_BIT
    }
    #[doc = "Checks if the value of the field is `PWM_PHASE_CORRECT_10_BIT`"]
    #[inline(always)]
    pub fn is_pwm_phase_correct_10_bit(&self) -> bool {
        **self == WGM3_A::PWM_PHASE_CORRECT_10_BIT
    }
}
impl core::ops::Deref for WGM3_R {
    type Target = crate::FieldReader<u8, WGM3_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM3` writer - Waveform Generation Mode"]
pub struct WGM3_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM3_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: WGM3_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Normal mode of operation"]
    #[inline(always)]
    pub fn normal_mode_of_operation(self) -> &'a mut W {
        self.variant(WGM3_A::NORMAL_MODE_OF_OPERATION)
    }
    #[doc = "PWM, phase correct, 8-bit"]
    #[inline(always)]
    pub fn pwm_phase_correct_8_bit(self) -> &'a mut W {
        self.variant(WGM3_A::PWM_PHASE_CORRECT_8_BIT)
    }
    #[doc = "PWM, phase correct, 9-bit"]
    #[inline(always)]
    pub fn pwm_phase_correct_9_bit(self) -> &'a mut W {
        self.variant(WGM3_A::PWM_PHASE_CORRECT_9_BIT)
    }
    #[doc = "PWM, phase correct, 10-bit"]
    #[inline(always)]
    pub fn pwm_phase_correct_10_bit(self) -> &'a mut W {
        self.variant(WGM3_A::PWM_PHASE_CORRECT_10_BIT)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Compare Output Mode for Channel C\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum COM3C_A {
    #[doc = "0: Normal port operation, OCnA/OCnB/OCnC disconnected."]
    NORMAL_PORT_OPERATION_OCNA_OCNB_OCNC_DISCONNECTED = 0,
    #[doc = "1: Toggle OCnA/OCnB/OCnC on Compare Match."]
    TOGGLE_OCNA_OCNB_OCNC_ON_COMPARE_MATCH = 1,
    #[doc = "2: Clear OCnA/OCnB/OCnC on Compare Match (set output to low level)."]
    CLEAR_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_LOW_LEVEL = 2,
    #[doc = "3: Set OCnA/OCnB/OCnC on Compare Match (set output to high level)."]
    SET_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_HIGH_LEVEL = 3,
}
impl From<COM3C_A> for u8 {
    #[inline(always)]
    fn from(variant: COM3C_A) -> Self {
        variant as _
    }
}
#[doc = "Field `COM3C` reader - Compare Output Mode for Channel C"]
pub struct COM3C_R(crate::FieldReader<u8, COM3C_A>);
impl COM3C_R {
    pub(crate) fn new(bits: u8) -> Self {
        COM3C_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> COM3C_A {
        match self.bits {
            0 => COM3C_A::NORMAL_PORT_OPERATION_OCNA_OCNB_OCNC_DISCONNECTED,
            1 => COM3C_A::TOGGLE_OCNA_OCNB_OCNC_ON_COMPARE_MATCH,
            2 => COM3C_A::CLEAR_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_LOW_LEVEL,
            3 => COM3C_A::SET_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_HIGH_LEVEL,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NORMAL_PORT_OPERATION_OCNA_OCNB_OCNC_DISCONNECTED`"]
    #[inline(always)]
    pub fn is_normal_port_operation_ocna_ocnb_ocnc_disconnected(&self) -> bool {
        **self == COM3C_A::NORMAL_PORT_OPERATION_OCNA_OCNB_OCNC_DISCONNECTED
    }
    #[doc = "Checks if the value of the field is `TOGGLE_OCNA_OCNB_OCNC_ON_COMPARE_MATCH`"]
    #[inline(always)]
    pub fn is_toggle_ocna_ocnb_ocnc_on_compare_match(&self) -> bool {
        **self == COM3C_A::TOGGLE_OCNA_OCNB_OCNC_ON_COMPARE_MATCH
    }
    #[doc = "Checks if the value of the field is `CLEAR_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_LOW_LEVEL`"]
    #[inline(always)]
    pub fn is_clear_ocna_ocnb_ocnc_on_compare_match_set_output_to_low_level(&self) -> bool {
        **self == COM3C_A::CLEAR_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_LOW_LEVEL
    }
    #[doc = "Checks if the value of the field is `SET_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_HIGH_LEVEL`"]
    #[inline(always)]
    pub fn is_set_ocna_ocnb_ocnc_on_compare_match_set_output_to_high_level(&self) -> bool {
        **self == COM3C_A::SET_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_HIGH_LEVEL
    }
}
impl core::ops::Deref for COM3C_R {
    type Target = crate::FieldReader<u8, COM3C_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COM3C` writer - Compare Output Mode for Channel C"]
pub struct COM3C_W<'a> {
    w: &'a mut W,
}
impl<'a> COM3C_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: COM3C_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Normal port operation, OCnA/OCnB/OCnC disconnected."]
    #[inline(always)]
    pub fn normal_port_operation_ocna_ocnb_ocnc_disconnected(self) -> &'a mut W {
        self.variant(COM3C_A::NORMAL_PORT_OPERATION_OCNA_OCNB_OCNC_DISCONNECTED)
    }
    #[doc = "Toggle OCnA/OCnB/OCnC on Compare Match."]
    #[inline(always)]
    pub fn toggle_ocna_ocnb_ocnc_on_compare_match(self) -> &'a mut W {
        self.variant(COM3C_A::TOGGLE_OCNA_OCNB_OCNC_ON_COMPARE_MATCH)
    }
    #[doc = "Clear OCnA/OCnB/OCnC on Compare Match (set output to low level)."]
    #[inline(always)]
    pub fn clear_ocna_ocnb_ocnc_on_compare_match_set_output_to_low_level(self) -> &'a mut W {
        self.variant(COM3C_A::CLEAR_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_LOW_LEVEL)
    }
    #[doc = "Set OCnA/OCnB/OCnC on Compare Match (set output to high level)."]
    #[inline(always)]
    pub fn set_ocna_ocnb_ocnc_on_compare_match_set_output_to_high_level(self) -> &'a mut W {
        self.variant(COM3C_A::SET_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_HIGH_LEVEL)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u8 & 0x03) << 2);
        self.w
    }
}
#[doc = "Compare Output Mode for Channel B\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum COM3B_A {
    #[doc = "0: Normal port operation, OCnA/OCnB/OCnC disconnected."]
    NORMAL_PORT_OPERATION_OCNA_OCNB_OCNC_DISCONNECTED = 0,
    #[doc = "1: Toggle OCnA/OCnB/OCnC on Compare Match."]
    TOGGLE_OCNA_OCNB_OCNC_ON_COMPARE_MATCH = 1,
    #[doc = "2: Clear OCnA/OCnB/OCnC on Compare Match (set output to low level)."]
    CLEAR_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_LOW_LEVEL = 2,
    #[doc = "3: Set OCnA/OCnB/OCnC on Compare Match (set output to high level)."]
    SET_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_HIGH_LEVEL = 3,
}
impl From<COM3B_A> for u8 {
    #[inline(always)]
    fn from(variant: COM3B_A) -> Self {
        variant as _
    }
}
#[doc = "Field `COM3B` reader - Compare Output Mode for Channel B"]
pub struct COM3B_R(crate::FieldReader<u8, COM3B_A>);
impl COM3B_R {
    pub(crate) fn new(bits: u8) -> Self {
        COM3B_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> COM3B_A {
        match self.bits {
            0 => COM3B_A::NORMAL_PORT_OPERATION_OCNA_OCNB_OCNC_DISCONNECTED,
            1 => COM3B_A::TOGGLE_OCNA_OCNB_OCNC_ON_COMPARE_MATCH,
            2 => COM3B_A::CLEAR_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_LOW_LEVEL,
            3 => COM3B_A::SET_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_HIGH_LEVEL,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NORMAL_PORT_OPERATION_OCNA_OCNB_OCNC_DISCONNECTED`"]
    #[inline(always)]
    pub fn is_normal_port_operation_ocna_ocnb_ocnc_disconnected(&self) -> bool {
        **self == COM3B_A::NORMAL_PORT_OPERATION_OCNA_OCNB_OCNC_DISCONNECTED
    }
    #[doc = "Checks if the value of the field is `TOGGLE_OCNA_OCNB_OCNC_ON_COMPARE_MATCH`"]
    #[inline(always)]
    pub fn is_toggle_ocna_ocnb_ocnc_on_compare_match(&self) -> bool {
        **self == COM3B_A::TOGGLE_OCNA_OCNB_OCNC_ON_COMPARE_MATCH
    }
    #[doc = "Checks if the value of the field is `CLEAR_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_LOW_LEVEL`"]
    #[inline(always)]
    pub fn is_clear_ocna_ocnb_ocnc_on_compare_match_set_output_to_low_level(&self) -> bool {
        **self == COM3B_A::CLEAR_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_LOW_LEVEL
    }
    #[doc = "Checks if the value of the field is `SET_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_HIGH_LEVEL`"]
    #[inline(always)]
    pub fn is_set_ocna_ocnb_ocnc_on_compare_match_set_output_to_high_level(&self) -> bool {
        **self == COM3B_A::SET_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_HIGH_LEVEL
    }
}
impl core::ops::Deref for COM3B_R {
    type Target = crate::FieldReader<u8, COM3B_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COM3B` writer - Compare Output Mode for Channel B"]
pub struct COM3B_W<'a> {
    w: &'a mut W,
}
impl<'a> COM3B_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: COM3B_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Normal port operation, OCnA/OCnB/OCnC disconnected."]
    #[inline(always)]
    pub fn normal_port_operation_ocna_ocnb_ocnc_disconnected(self) -> &'a mut W {
        self.variant(COM3B_A::NORMAL_PORT_OPERATION_OCNA_OCNB_OCNC_DISCONNECTED)
    }
    #[doc = "Toggle OCnA/OCnB/OCnC on Compare Match."]
    #[inline(always)]
    pub fn toggle_ocna_ocnb_ocnc_on_compare_match(self) -> &'a mut W {
        self.variant(COM3B_A::TOGGLE_OCNA_OCNB_OCNC_ON_COMPARE_MATCH)
    }
    #[doc = "Clear OCnA/OCnB/OCnC on Compare Match (set output to low level)."]
    #[inline(always)]
    pub fn clear_ocna_ocnb_ocnc_on_compare_match_set_output_to_low_level(self) -> &'a mut W {
        self.variant(COM3B_A::CLEAR_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_LOW_LEVEL)
    }
    #[doc = "Set OCnA/OCnB/OCnC on Compare Match (set output to high level)."]
    #[inline(always)]
    pub fn set_ocna_ocnb_ocnc_on_compare_match_set_output_to_high_level(self) -> &'a mut W {
        self.variant(COM3B_A::SET_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_HIGH_LEVEL)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Compare Output Mode for Channel A\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum COM3A_A {
    #[doc = "0: Normal port operation, OCnA/OCnB/OCnC disconnected."]
    NORMAL_PORT_OPERATION_OCNA_OCNB_OCNC_DISCONNECTED = 0,
    #[doc = "1: Toggle OCnA/OCnB/OCnC on Compare Match."]
    TOGGLE_OCNA_OCNB_OCNC_ON_COMPARE_MATCH = 1,
    #[doc = "2: Clear OCnA/OCnB/OCnC on Compare Match (set output to low level)."]
    CLEAR_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_LOW_LEVEL = 2,
    #[doc = "3: Set OCnA/OCnB/OCnC on Compare Match (set output to high level)."]
    SET_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_HIGH_LEVEL = 3,
}
impl From<COM3A_A> for u8 {
    #[inline(always)]
    fn from(variant: COM3A_A) -> Self {
        variant as _
    }
}
#[doc = "Field `COM3A` reader - Compare Output Mode for Channel A"]
pub struct COM3A_R(crate::FieldReader<u8, COM3A_A>);
impl COM3A_R {
    pub(crate) fn new(bits: u8) -> Self {
        COM3A_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> COM3A_A {
        match self.bits {
            0 => COM3A_A::NORMAL_PORT_OPERATION_OCNA_OCNB_OCNC_DISCONNECTED,
            1 => COM3A_A::TOGGLE_OCNA_OCNB_OCNC_ON_COMPARE_MATCH,
            2 => COM3A_A::CLEAR_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_LOW_LEVEL,
            3 => COM3A_A::SET_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_HIGH_LEVEL,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NORMAL_PORT_OPERATION_OCNA_OCNB_OCNC_DISCONNECTED`"]
    #[inline(always)]
    pub fn is_normal_port_operation_ocna_ocnb_ocnc_disconnected(&self) -> bool {
        **self == COM3A_A::NORMAL_PORT_OPERATION_OCNA_OCNB_OCNC_DISCONNECTED
    }
    #[doc = "Checks if the value of the field is `TOGGLE_OCNA_OCNB_OCNC_ON_COMPARE_MATCH`"]
    #[inline(always)]
    pub fn is_toggle_ocna_ocnb_ocnc_on_compare_match(&self) -> bool {
        **self == COM3A_A::TOGGLE_OCNA_OCNB_OCNC_ON_COMPARE_MATCH
    }
    #[doc = "Checks if the value of the field is `CLEAR_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_LOW_LEVEL`"]
    #[inline(always)]
    pub fn is_clear_ocna_ocnb_ocnc_on_compare_match_set_output_to_low_level(&self) -> bool {
        **self == COM3A_A::CLEAR_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_LOW_LEVEL
    }
    #[doc = "Checks if the value of the field is `SET_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_HIGH_LEVEL`"]
    #[inline(always)]
    pub fn is_set_ocna_ocnb_ocnc_on_compare_match_set_output_to_high_level(&self) -> bool {
        **self == COM3A_A::SET_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_HIGH_LEVEL
    }
}
impl core::ops::Deref for COM3A_R {
    type Target = crate::FieldReader<u8, COM3A_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COM3A` writer - Compare Output Mode for Channel A"]
pub struct COM3A_W<'a> {
    w: &'a mut W,
}
impl<'a> COM3A_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: COM3A_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Normal port operation, OCnA/OCnB/OCnC disconnected."]
    #[inline(always)]
    pub fn normal_port_operation_ocna_ocnb_ocnc_disconnected(self) -> &'a mut W {
        self.variant(COM3A_A::NORMAL_PORT_OPERATION_OCNA_OCNB_OCNC_DISCONNECTED)
    }
    #[doc = "Toggle OCnA/OCnB/OCnC on Compare Match."]
    #[inline(always)]
    pub fn toggle_ocna_ocnb_ocnc_on_compare_match(self) -> &'a mut W {
        self.variant(COM3A_A::TOGGLE_OCNA_OCNB_OCNC_ON_COMPARE_MATCH)
    }
    #[doc = "Clear OCnA/OCnB/OCnC on Compare Match (set output to low level)."]
    #[inline(always)]
    pub fn clear_ocna_ocnb_ocnc_on_compare_match_set_output_to_low_level(self) -> &'a mut W {
        self.variant(COM3A_A::CLEAR_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_LOW_LEVEL)
    }
    #[doc = "Set OCnA/OCnB/OCnC on Compare Match (set output to high level)."]
    #[inline(always)]
    pub fn set_ocna_ocnb_ocnc_on_compare_match_set_output_to_high_level(self) -> &'a mut W {
        self.variant(COM3A_A::SET_OCNA_OCNB_OCNC_ON_COMPARE_MATCH_SET_OUTPUT_TO_HIGH_LEVEL)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm3(&self) -> WGM3_R {
        WGM3_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - Compare Output Mode for Channel C"]
    #[inline(always)]
    pub fn com3c(&self) -> COM3C_R {
        COM3C_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 4:5 - Compare Output Mode for Channel B"]
    #[inline(always)]
    pub fn com3b(&self) -> COM3B_R {
        COM3B_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 6:7 - Compare Output Mode for Channel A"]
    #[inline(always)]
    pub fn com3a(&self) -> COM3A_R {
        COM3A_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:1 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm3(&mut self) -> WGM3_W {
        WGM3_W { w: self }
    }
    #[doc = "Bits 2:3 - Compare Output Mode for Channel C"]
    #[inline(always)]
    pub fn com3c(&mut self) -> COM3C_W {
        COM3C_W { w: self }
    }
    #[doc = "Bits 4:5 - Compare Output Mode for Channel B"]
    #[inline(always)]
    pub fn com3b(&mut self) -> COM3B_W {
        COM3B_W { w: self }
    }
    #[doc = "Bits 6:7 - Compare Output Mode for Channel A"]
    #[inline(always)]
    pub fn com3a(&mut self) -> COM3A_W {
        COM3A_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter3 Control Register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr3a](index.html) module"]
pub struct TCCR3A_SPEC;
impl crate::RegisterSpec for TCCR3A_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr3a::R](R) reader structure"]
impl crate::Readable for TCCR3A_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr3a::W](W) writer structure"]
impl crate::Writable for TCCR3A_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR3A to value 0"]
impl crate::Resettable for TCCR3A_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
