#[doc = "Register `TCCR2B` reader"]
pub struct R(crate::R<TCCR2B_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR2B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR2B_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR2B_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR2B` writer"]
pub struct W(crate::W<TCCR2B_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR2B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR2B_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR2B_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Clock Select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CS2_A {
    #[doc = "0: No clock source (Timer/Counter2 stopped)"]
    NO_CLOCK_SOURCE_TIMER_COUNTER2_STOPPED = 0,
    #[doc = "1: clk_T2S/1 (no prescaling)"]
    CLK_T2S_1_NO_PRESCALING = 1,
    #[doc = "2: clk_T2S/8 (from prescaler)"]
    CLK_T2S_8_FROM_PRESCALER = 2,
    #[doc = "3: clk_T2S/32 (from prescaler)"]
    CLK_T2S_32_FROM_PRESCALER = 3,
    #[doc = "4: clk_T2S/64 (from prescaler)"]
    CLK_T2S_64_FROM_PRESCALER = 4,
    #[doc = "5: clk_T2S/128 (from prescaler)"]
    CLK_T2S_128_FROM_PRESCALER = 5,
    #[doc = "6: clk_T2S/256 (from prescaler)"]
    CLK_T2S_256_FROM_PRESCALER = 6,
    #[doc = "7: clk_T2S/1024 (from prescaler)"]
    CLK_T2S_1024_FROM_PRESCALER = 7,
}
impl From<CS2_A> for u8 {
    #[inline(always)]
    fn from(variant: CS2_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CS2` reader - Clock Select"]
pub struct CS2_R(crate::FieldReader<u8, CS2_A>);
impl CS2_R {
    pub(crate) fn new(bits: u8) -> Self {
        CS2_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CS2_A {
        match self.bits {
            0 => CS2_A::NO_CLOCK_SOURCE_TIMER_COUNTER2_STOPPED,
            1 => CS2_A::CLK_T2S_1_NO_PRESCALING,
            2 => CS2_A::CLK_T2S_8_FROM_PRESCALER,
            3 => CS2_A::CLK_T2S_32_FROM_PRESCALER,
            4 => CS2_A::CLK_T2S_64_FROM_PRESCALER,
            5 => CS2_A::CLK_T2S_128_FROM_PRESCALER,
            6 => CS2_A::CLK_T2S_256_FROM_PRESCALER,
            7 => CS2_A::CLK_T2S_1024_FROM_PRESCALER,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NO_CLOCK_SOURCE_TIMER_COUNTER2_STOPPED`"]
    #[inline(always)]
    pub fn is_no_clock_source_timer_counter2_stopped(&self) -> bool {
        **self == CS2_A::NO_CLOCK_SOURCE_TIMER_COUNTER2_STOPPED
    }
    #[doc = "Checks if the value of the field is `CLK_T2S_1_NO_PRESCALING`"]
    #[inline(always)]
    pub fn is_clk_t2s_1_no_prescaling(&self) -> bool {
        **self == CS2_A::CLK_T2S_1_NO_PRESCALING
    }
    #[doc = "Checks if the value of the field is `CLK_T2S_8_FROM_PRESCALER`"]
    #[inline(always)]
    pub fn is_clk_t2s_8_from_prescaler(&self) -> bool {
        **self == CS2_A::CLK_T2S_8_FROM_PRESCALER
    }
    #[doc = "Checks if the value of the field is `CLK_T2S_32_FROM_PRESCALER`"]
    #[inline(always)]
    pub fn is_clk_t2s_32_from_prescaler(&self) -> bool {
        **self == CS2_A::CLK_T2S_32_FROM_PRESCALER
    }
    #[doc = "Checks if the value of the field is `CLK_T2S_64_FROM_PRESCALER`"]
    #[inline(always)]
    pub fn is_clk_t2s_64_from_prescaler(&self) -> bool {
        **self == CS2_A::CLK_T2S_64_FROM_PRESCALER
    }
    #[doc = "Checks if the value of the field is `CLK_T2S_128_FROM_PRESCALER`"]
    #[inline(always)]
    pub fn is_clk_t2s_128_from_prescaler(&self) -> bool {
        **self == CS2_A::CLK_T2S_128_FROM_PRESCALER
    }
    #[doc = "Checks if the value of the field is `CLK_T2S_256_FROM_PRESCALER`"]
    #[inline(always)]
    pub fn is_clk_t2s_256_from_prescaler(&self) -> bool {
        **self == CS2_A::CLK_T2S_256_FROM_PRESCALER
    }
    #[doc = "Checks if the value of the field is `CLK_T2S_1024_FROM_PRESCALER`"]
    #[inline(always)]
    pub fn is_clk_t2s_1024_from_prescaler(&self) -> bool {
        **self == CS2_A::CLK_T2S_1024_FROM_PRESCALER
    }
}
impl core::ops::Deref for CS2_R {
    type Target = crate::FieldReader<u8, CS2_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CS2` writer - Clock Select"]
pub struct CS2_W<'a> {
    w: &'a mut W,
}
impl<'a> CS2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CS2_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "No clock source (Timer/Counter2 stopped)"]
    #[inline(always)]
    pub fn no_clock_source_timer_counter2_stopped(self) -> &'a mut W {
        self.variant(CS2_A::NO_CLOCK_SOURCE_TIMER_COUNTER2_STOPPED)
    }
    #[doc = "clk_T2S/1 (no prescaling)"]
    #[inline(always)]
    pub fn clk_t2s_1_no_prescaling(self) -> &'a mut W {
        self.variant(CS2_A::CLK_T2S_1_NO_PRESCALING)
    }
    #[doc = "clk_T2S/8 (from prescaler)"]
    #[inline(always)]
    pub fn clk_t2s_8_from_prescaler(self) -> &'a mut W {
        self.variant(CS2_A::CLK_T2S_8_FROM_PRESCALER)
    }
    #[doc = "clk_T2S/32 (from prescaler)"]
    #[inline(always)]
    pub fn clk_t2s_32_from_prescaler(self) -> &'a mut W {
        self.variant(CS2_A::CLK_T2S_32_FROM_PRESCALER)
    }
    #[doc = "clk_T2S/64 (from prescaler)"]
    #[inline(always)]
    pub fn clk_t2s_64_from_prescaler(self) -> &'a mut W {
        self.variant(CS2_A::CLK_T2S_64_FROM_PRESCALER)
    }
    #[doc = "clk_T2S/128 (from prescaler)"]
    #[inline(always)]
    pub fn clk_t2s_128_from_prescaler(self) -> &'a mut W {
        self.variant(CS2_A::CLK_T2S_128_FROM_PRESCALER)
    }
    #[doc = "clk_T2S/256 (from prescaler)"]
    #[inline(always)]
    pub fn clk_t2s_256_from_prescaler(self) -> &'a mut W {
        self.variant(CS2_A::CLK_T2S_256_FROM_PRESCALER)
    }
    #[doc = "clk_T2S/1024 (from prescaler)"]
    #[inline(always)]
    pub fn clk_t2s_1024_from_prescaler(self) -> &'a mut W {
        self.variant(CS2_A::CLK_T2S_1024_FROM_PRESCALER)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `WGM22` reader - Waveform Generation Mode"]
pub struct WGM22_R(crate::FieldReader<bool, bool>);
impl WGM22_R {
    pub(crate) fn new(bits: bool) -> Self {
        WGM22_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WGM22_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM22` writer - Waveform Generation Mode"]
pub struct WGM22_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM22_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `Res` reader - Reserved"]
pub struct RES_R(crate::FieldReader<u8, u8>);
impl RES_R {
    pub(crate) fn new(bits: u8) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `FOC2B` reader - Force Output Compare B"]
pub struct FOC2B_R(crate::FieldReader<bool, bool>);
impl FOC2B_R {
    pub(crate) fn new(bits: bool) -> Self {
        FOC2B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FOC2B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FOC2B` writer - Force Output Compare B"]
pub struct FOC2B_W<'a> {
    w: &'a mut W,
}
impl<'a> FOC2B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `FOC2A` reader - Force Output Compare A"]
pub struct FOC2A_R(crate::FieldReader<bool, bool>);
impl FOC2A_R {
    pub(crate) fn new(bits: bool) -> Self {
        FOC2A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FOC2A_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FOC2A` writer - Force Output Compare A"]
pub struct FOC2A_W<'a> {
    w: &'a mut W,
}
impl<'a> FOC2A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Clock Select"]
    #[inline(always)]
    pub fn cs2(&self) -> CS2_R {
        CS2_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bit 3 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm22(&self) -> WGM22_R {
        WGM22_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bits 4:5 - Reserved"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bit 6 - Force Output Compare B"]
    #[inline(always)]
    pub fn foc2b(&self) -> FOC2B_R {
        FOC2B_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Force Output Compare A"]
    #[inline(always)]
    pub fn foc2a(&self) -> FOC2A_R {
        FOC2A_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - Clock Select"]
    #[inline(always)]
    pub fn cs2(&mut self) -> CS2_W {
        CS2_W { w: self }
    }
    #[doc = "Bit 3 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm22(&mut self) -> WGM22_W {
        WGM22_W { w: self }
    }
    #[doc = "Bits 4:5 - Reserved"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Bit 6 - Force Output Compare B"]
    #[inline(always)]
    pub fn foc2b(&mut self) -> FOC2B_W {
        FOC2B_W { w: self }
    }
    #[doc = "Bit 7 - Force Output Compare A"]
    #[inline(always)]
    pub fn foc2a(&mut self) -> FOC2A_W {
        FOC2A_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter2 Control Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr2b](index.html) module"]
pub struct TCCR2B_SPEC;
impl crate::RegisterSpec for TCCR2B_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr2b::R](R) reader structure"]
impl crate::Readable for TCCR2B_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr2b::W](W) writer structure"]
impl crate::Writable for TCCR2B_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR2B to value 0"]
impl crate::Resettable for TCCR2B_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
