#[doc = "Register `GTCCR` reader"]
pub struct R(crate::R<GTCCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GTCCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GTCCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GTCCR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GTCCR` writer"]
pub struct W(crate::W<GTCCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GTCCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GTCCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GTCCR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PSRSYNC` reader - Prescaler Reset for Synchronous Timer/Counters"]
pub struct PSRSYNC_R(crate::FieldReader<bool, bool>);
impl PSRSYNC_R {
    pub(crate) fn new(bits: bool) -> Self {
        PSRSYNC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PSRSYNC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PSRSYNC` writer - Prescaler Reset for Synchronous Timer/Counters"]
pub struct PSRSYNC_W<'a> {
    w: &'a mut W,
}
impl<'a> PSRSYNC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `PSRASY` reader - Prescaler Reset Timer/Counter2"]
pub struct PSRASY_R(crate::FieldReader<bool, bool>);
impl PSRASY_R {
    pub(crate) fn new(bits: bool) -> Self {
        PSRASY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PSRASY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PSRASY` writer - Prescaler Reset Timer/Counter2"]
pub struct PSRASY_W<'a> {
    w: &'a mut W,
}
impl<'a> PSRASY_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `Res` reader - Reserved"]
pub struct RES_R(crate::FieldReader<u8, u8>);
impl RES_R {
    pub(crate) fn new(bits: u8) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 2)) | ((value as u8 & 0x1f) << 2);
        self.w
    }
}
#[doc = "Field `TSM` reader - Timer/Counter Synchronization Mode"]
pub struct TSM_R(crate::FieldReader<bool, bool>);
impl TSM_R {
    pub(crate) fn new(bits: bool) -> Self {
        TSM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TSM_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TSM` writer - Timer/Counter Synchronization Mode"]
pub struct TSM_W<'a> {
    w: &'a mut W,
}
impl<'a> TSM_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Prescaler Reset for Synchronous Timer/Counters"]
    #[inline(always)]
    pub fn psrsync(&self) -> PSRSYNC_R {
        PSRSYNC_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Prescaler Reset Timer/Counter2"]
    #[inline(always)]
    pub fn psrasy(&self) -> PSRASY_R {
        PSRASY_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bits 2:6 - Reserved"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new(((self.bits >> 2) & 0x1f) as u8)
    }
    #[doc = "Bit 7 - Timer/Counter Synchronization Mode"]
    #[inline(always)]
    pub fn tsm(&self) -> TSM_R {
        TSM_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Prescaler Reset for Synchronous Timer/Counters"]
    #[inline(always)]
    pub fn psrsync(&mut self) -> PSRSYNC_W {
        PSRSYNC_W { w: self }
    }
    #[doc = "Bit 1 - Prescaler Reset Timer/Counter2"]
    #[inline(always)]
    pub fn psrasy(&mut self) -> PSRASY_W {
        PSRASY_W { w: self }
    }
    #[doc = "Bits 2:6 - Reserved"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Bit 7 - Timer/Counter Synchronization Mode"]
    #[inline(always)]
    pub fn tsm(&mut self) -> TSM_W {
        TSM_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "General Timer/Counter Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gtccr](index.html) module"]
pub struct GTCCR_SPEC;
impl crate::RegisterSpec for GTCCR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [gtccr::R](R) reader structure"]
impl crate::Readable for GTCCR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gtccr::W](W) writer structure"]
impl crate::Writable for GTCCR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GTCCR to value 0"]
impl crate::Resettable for GTCCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
