#[doc = "Register `SCIRQS` reader"]
pub struct R(crate::R<SCIRQS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SCIRQS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SCIRQS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SCIRQS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SCIRQS` writer"]
pub struct W(crate::W<SCIRQS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SCIRQS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SCIRQS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SCIRQS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `IRQSCP` reader - Compare Unit 3 Compare Match IRQ"]
pub struct IRQSCP_R(crate::FieldReader<u8, u8>);
impl IRQSCP_R {
    pub(crate) fn new(bits: u8) -> Self {
        IRQSCP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IRQSCP_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IRQSCP` writer - Compare Unit 3 Compare Match IRQ"]
pub struct IRQSCP_W<'a> {
    w: &'a mut W,
}
impl<'a> IRQSCP_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `IRQSOF` reader - Symbol Counter Overflow IRQ"]
pub struct IRQSOF_R(crate::FieldReader<bool, bool>);
impl IRQSOF_R {
    pub(crate) fn new(bits: bool) -> Self {
        IRQSOF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IRQSOF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IRQSOF` writer - Symbol Counter Overflow IRQ"]
pub struct IRQSOF_W<'a> {
    w: &'a mut W,
}
impl<'a> IRQSOF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `IRQSBO` reader - Backoff Slot Counter IRQ"]
pub struct IRQSBO_R(crate::FieldReader<bool, bool>);
impl IRQSBO_R {
    pub(crate) fn new(bits: bool) -> Self {
        IRQSBO_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IRQSBO_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IRQSBO` writer - Backoff Slot Counter IRQ"]
pub struct IRQSBO_W<'a> {
    w: &'a mut W,
}
impl<'a> IRQSBO_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `Res` reader - Reserved Bit"]
pub struct RES_R(crate::FieldReader<u8, u8>);
impl RES_R {
    pub(crate) fn new(bits: u8) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved Bit"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 5)) | ((value as u8 & 0x07) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Compare Unit 3 Compare Match IRQ"]
    #[inline(always)]
    pub fn irqscp(&self) -> IRQSCP_R {
        IRQSCP_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bit 3 - Symbol Counter Overflow IRQ"]
    #[inline(always)]
    pub fn irqsof(&self) -> IRQSOF_R {
        IRQSOF_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Backoff Slot Counter IRQ"]
    #[inline(always)]
    pub fn irqsbo(&self) -> IRQSBO_R {
        IRQSBO_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bits 5:7 - Reserved Bit"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new(((self.bits >> 5) & 0x07) as u8)
    }
}
impl W {
    #[doc = "Bits 0:2 - Compare Unit 3 Compare Match IRQ"]
    #[inline(always)]
    pub fn irqscp(&mut self) -> IRQSCP_W {
        IRQSCP_W { w: self }
    }
    #[doc = "Bit 3 - Symbol Counter Overflow IRQ"]
    #[inline(always)]
    pub fn irqsof(&mut self) -> IRQSOF_W {
        IRQSOF_W { w: self }
    }
    #[doc = "Bit 4 - Backoff Slot Counter IRQ"]
    #[inline(always)]
    pub fn irqsbo(&mut self) -> IRQSBO_W {
        IRQSBO_W { w: self }
    }
    #[doc = "Bits 5:7 - Reserved Bit"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Symbol Counter Interrupt Status Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [scirqs](index.html) module"]
pub struct SCIRQS_SPEC;
impl crate::RegisterSpec for SCIRQS_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [scirqs::R](R) reader structure"]
impl crate::Readable for SCIRQS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [scirqs::W](W) writer structure"]
impl crate::Writable for SCIRQS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SCIRQS to value 0"]
impl crate::Resettable for SCIRQS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
