#[doc = "Register `SCIRQM` reader"]
pub struct R(crate::R<SCIRQM_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SCIRQM_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SCIRQM_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SCIRQM_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SCIRQM` writer"]
pub struct W(crate::W<SCIRQM_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SCIRQM_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SCIRQM_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SCIRQM_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `IRQMCP` reader - Symbol Counter Compare Match 3 IRQ enable"]
pub struct IRQMCP_R(crate::FieldReader<u8, u8>);
impl IRQMCP_R {
    pub(crate) fn new(bits: u8) -> Self {
        IRQMCP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IRQMCP_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IRQMCP` writer - Symbol Counter Compare Match 3 IRQ enable"]
pub struct IRQMCP_W<'a> {
    w: &'a mut W,
}
impl<'a> IRQMCP_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `IRQMOF` reader - Symbol Counter Overflow IRQ enable"]
pub struct IRQMOF_R(crate::FieldReader<bool, bool>);
impl IRQMOF_R {
    pub(crate) fn new(bits: bool) -> Self {
        IRQMOF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IRQMOF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IRQMOF` writer - Symbol Counter Overflow IRQ enable"]
pub struct IRQMOF_W<'a> {
    w: &'a mut W,
}
impl<'a> IRQMOF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `IRQMBO` reader - Backoff Slot Counter IRQ enable"]
pub struct IRQMBO_R(crate::FieldReader<bool, bool>);
impl IRQMBO_R {
    pub(crate) fn new(bits: bool) -> Self {
        IRQMBO_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IRQMBO_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IRQMBO` writer - Backoff Slot Counter IRQ enable"]
pub struct IRQMBO_W<'a> {
    w: &'a mut W,
}
impl<'a> IRQMBO_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `Res` reader - Reserved Bit"]
pub struct RES_R(crate::FieldReader<u8, u8>);
impl RES_R {
    pub(crate) fn new(bits: u8) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved Bit"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 5)) | ((value as u8 & 0x07) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Symbol Counter Compare Match 3 IRQ enable"]
    #[inline(always)]
    pub fn irqmcp(&self) -> IRQMCP_R {
        IRQMCP_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bit 3 - Symbol Counter Overflow IRQ enable"]
    #[inline(always)]
    pub fn irqmof(&self) -> IRQMOF_R {
        IRQMOF_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Backoff Slot Counter IRQ enable"]
    #[inline(always)]
    pub fn irqmbo(&self) -> IRQMBO_R {
        IRQMBO_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bits 5:7 - Reserved Bit"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new(((self.bits >> 5) & 0x07) as u8)
    }
}
impl W {
    #[doc = "Bits 0:2 - Symbol Counter Compare Match 3 IRQ enable"]
    #[inline(always)]
    pub fn irqmcp(&mut self) -> IRQMCP_W {
        IRQMCP_W { w: self }
    }
    #[doc = "Bit 3 - Symbol Counter Overflow IRQ enable"]
    #[inline(always)]
    pub fn irqmof(&mut self) -> IRQMOF_W {
        IRQMOF_W { w: self }
    }
    #[doc = "Bit 4 - Backoff Slot Counter IRQ enable"]
    #[inline(always)]
    pub fn irqmbo(&mut self) -> IRQMBO_W {
        IRQMBO_W { w: self }
    }
    #[doc = "Bits 5:7 - Reserved Bit"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Symbol Counter Interrupt Mask Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [scirqm](index.html) module"]
pub struct SCIRQM_SPEC;
impl crate::RegisterSpec for SCIRQM_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [scirqm::R](R) reader structure"]
impl crate::Readable for SCIRQM_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [scirqm::W](W) writer structure"]
impl crate::Writable for SCIRQM_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SCIRQM to value 0"]
impl crate::Resettable for SCIRQM_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
