#[doc = "Register `SCCR0` reader"]
pub struct R(crate::R<SCCR0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SCCR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SCCR0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SCCR0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SCCR0` writer"]
pub struct W(crate::W<SCCR0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SCCR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SCCR0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SCCR0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SCCMP` reader - Symbol Counter Compare Unit 3 Mode select"]
pub struct SCCMP_R(crate::FieldReader<u8, u8>);
impl SCCMP_R {
    pub(crate) fn new(bits: u8) -> Self {
        SCCMP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCCMP_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCCMP` writer - Symbol Counter Compare Unit 3 Mode select"]
pub struct SCCMP_W<'a> {
    w: &'a mut W,
}
impl<'a> SCCMP_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `SCTSE` reader - Symbol Counter Automatic Timestamping enable"]
pub struct SCTSE_R(crate::FieldReader<bool, bool>);
impl SCTSE_R {
    pub(crate) fn new(bits: bool) -> Self {
        SCTSE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCTSE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCTSE` writer - Symbol Counter Automatic Timestamping enable"]
pub struct SCTSE_W<'a> {
    w: &'a mut W,
}
impl<'a> SCTSE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `SCCKSEL` reader - Symbol Counter Clock Source select"]
pub struct SCCKSEL_R(crate::FieldReader<bool, bool>);
impl SCCKSEL_R {
    pub(crate) fn new(bits: bool) -> Self {
        SCCKSEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCCKSEL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCCKSEL` writer - Symbol Counter Clock Source select"]
pub struct SCCKSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> SCCKSEL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `SCEN` reader - Symbol Counter enable"]
pub struct SCEN_R(crate::FieldReader<bool, bool>);
impl SCEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        SCEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCEN` writer - Symbol Counter enable"]
pub struct SCEN_W<'a> {
    w: &'a mut W,
}
impl<'a> SCEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `SCMBTS` reader - Manual Beacon Timestamp"]
pub struct SCMBTS_R(crate::FieldReader<bool, bool>);
impl SCMBTS_R {
    pub(crate) fn new(bits: bool) -> Self {
        SCMBTS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCMBTS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCMBTS` writer - Manual Beacon Timestamp"]
pub struct SCMBTS_W<'a> {
    w: &'a mut W,
}
impl<'a> SCMBTS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `SCRES` reader - Symbol Counter Synchronization"]
pub struct SCRES_R(crate::FieldReader<bool, bool>);
impl SCRES_R {
    pub(crate) fn new(bits: bool) -> Self {
        SCRES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCRES_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCRES` writer - Symbol Counter Synchronization"]
pub struct SCRES_W<'a> {
    w: &'a mut W,
}
impl<'a> SCRES_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Symbol Counter Compare Unit 3 Mode select"]
    #[inline(always)]
    pub fn sccmp(&self) -> SCCMP_R {
        SCCMP_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bit 3 - Symbol Counter Automatic Timestamping enable"]
    #[inline(always)]
    pub fn sctse(&self) -> SCTSE_R {
        SCTSE_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Symbol Counter Clock Source select"]
    #[inline(always)]
    pub fn sccksel(&self) -> SCCKSEL_R {
        SCCKSEL_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Symbol Counter enable"]
    #[inline(always)]
    pub fn scen(&self) -> SCEN_R {
        SCEN_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Manual Beacon Timestamp"]
    #[inline(always)]
    pub fn scmbts(&self) -> SCMBTS_R {
        SCMBTS_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Symbol Counter Synchronization"]
    #[inline(always)]
    pub fn scres(&self) -> SCRES_R {
        SCRES_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - Symbol Counter Compare Unit 3 Mode select"]
    #[inline(always)]
    pub fn sccmp(&mut self) -> SCCMP_W {
        SCCMP_W { w: self }
    }
    #[doc = "Bit 3 - Symbol Counter Automatic Timestamping enable"]
    #[inline(always)]
    pub fn sctse(&mut self) -> SCTSE_W {
        SCTSE_W { w: self }
    }
    #[doc = "Bit 4 - Symbol Counter Clock Source select"]
    #[inline(always)]
    pub fn sccksel(&mut self) -> SCCKSEL_W {
        SCCKSEL_W { w: self }
    }
    #[doc = "Bit 5 - Symbol Counter enable"]
    #[inline(always)]
    pub fn scen(&mut self) -> SCEN_W {
        SCEN_W { w: self }
    }
    #[doc = "Bit 6 - Manual Beacon Timestamp"]
    #[inline(always)]
    pub fn scmbts(&mut self) -> SCMBTS_W {
        SCMBTS_W { w: self }
    }
    #[doc = "Bit 7 - Symbol Counter Synchronization"]
    #[inline(always)]
    pub fn scres(&mut self) -> SCRES_W {
        SCRES_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Symbol Counter Control Register 0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [sccr0](index.html) module"]
pub struct SCCR0_SPEC;
impl crate::RegisterSpec for SCCR0_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [sccr0::R](R) reader structure"]
impl crate::Readable for SCCR0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [sccr0::W](W) writer structure"]
impl crate::Writable for SCCR0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SCCR0 to value 0"]
impl crate::Resettable for SCCR0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
