#[doc = "Register `TRXPR` reader"]
pub struct R(crate::R<TRXPR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TRXPR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TRXPR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TRXPR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TRXPR` writer"]
pub struct W(crate::W<TRXPR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TRXPR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TRXPR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TRXPR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TRXRST` reader - Force Transceiver Reset"]
pub struct TRXRST_R(crate::FieldReader<bool, bool>);
impl TRXRST_R {
    pub(crate) fn new(bits: bool) -> Self {
        TRXRST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TRXRST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TRXRST` writer - Force Transceiver Reset"]
pub struct TRXRST_W<'a> {
    w: &'a mut W,
}
impl<'a> TRXRST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `SLPTR` reader - Multi-purpose Transceiver Control Bit"]
pub struct SLPTR_R(crate::FieldReader<bool, bool>);
impl SLPTR_R {
    pub(crate) fn new(bits: bool) -> Self {
        SLPTR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLPTR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SLPTR` writer - Multi-purpose Transceiver Control Bit"]
pub struct SLPTR_W<'a> {
    w: &'a mut W,
}
impl<'a> SLPTR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `Res` reader - Reserved"]
pub struct RES_R(crate::FieldReader<u8, u8>);
impl RES_R {
    pub(crate) fn new(bits: u8) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u8 & 0x0f) << 4);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Force Transceiver Reset"]
    #[inline(always)]
    pub fn trxrst(&self) -> TRXRST_R {
        TRXRST_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Multi-purpose Transceiver Control Bit"]
    #[inline(always)]
    pub fn slptr(&self) -> SLPTR_R {
        SLPTR_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bits 4:7 - Reserved"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - Force Transceiver Reset"]
    #[inline(always)]
    pub fn trxrst(&mut self) -> TRXRST_W {
        TRXRST_W { w: self }
    }
    #[doc = "Bit 1 - Multi-purpose Transceiver Control Bit"]
    #[inline(always)]
    pub fn slptr(&mut self) -> SLPTR_W {
        SLPTR_W { w: self }
    }
    #[doc = "Bits 4:7 - Reserved"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Transceiver Pin Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [trxpr](index.html) module"]
pub struct TRXPR_SPEC;
impl crate::RegisterSpec for TRXPR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [trxpr::R](R) reader structure"]
impl crate::Readable for TRXPR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [trxpr::W](W) writer structure"]
impl crate::Writable for TRXPR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TRXPR to value 0"]
impl crate::Resettable for TRXPR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
