#[doc = "Register `LLDRL` reader"]
pub struct R(crate::R<LLDRL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LLDRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<LLDRL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<LLDRL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LLDRL` writer"]
pub struct W(crate::W<LLDRL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LLDRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<LLDRL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<LLDRL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Low-Byte Data Register Bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum LLDRL_A {
    #[doc = "0: Calibration limit for fast process corner/high output voltage"]
    CALIBRATION_LIMIT_FOR_FAST_PROCESS_CORNER_HIGH_OUTPUT_VOLTAGE = 0,
    #[doc = "8: Calibration limit for slow process corner/low output voltage"]
    CALIBRATION_LIMIT_FOR_SLOW_PROCESS_CORNER_LOW_OUTPUT_VOLTAGE = 8,
}
impl From<LLDRL_A> for u8 {
    #[inline(always)]
    fn from(variant: LLDRL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `LLDRL` reader - Low-Byte Data Register Bits"]
pub struct LLDRL_R(crate::FieldReader<u8, LLDRL_A>);
impl LLDRL_R {
    pub(crate) fn new(bits: u8) -> Self {
        LLDRL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<LLDRL_A> {
        match self.bits {
            0 => Some(LLDRL_A::CALIBRATION_LIMIT_FOR_FAST_PROCESS_CORNER_HIGH_OUTPUT_VOLTAGE),
            8 => Some(LLDRL_A::CALIBRATION_LIMIT_FOR_SLOW_PROCESS_CORNER_LOW_OUTPUT_VOLTAGE),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `CALIBRATION_LIMIT_FOR_FAST_PROCESS_CORNER_HIGH_OUTPUT_VOLTAGE`"]
    #[inline(always)]
    pub fn is_calibration_limit_for_fast_process_corner_high_output_voltage(&self) -> bool {
        **self == LLDRL_A::CALIBRATION_LIMIT_FOR_FAST_PROCESS_CORNER_HIGH_OUTPUT_VOLTAGE
    }
    #[doc = "Checks if the value of the field is `CALIBRATION_LIMIT_FOR_SLOW_PROCESS_CORNER_LOW_OUTPUT_VOLTAGE`"]
    #[inline(always)]
    pub fn is_calibration_limit_for_slow_process_corner_low_output_voltage(&self) -> bool {
        **self == LLDRL_A::CALIBRATION_LIMIT_FOR_SLOW_PROCESS_CORNER_LOW_OUTPUT_VOLTAGE
    }
}
impl core::ops::Deref for LLDRL_R {
    type Target = crate::FieldReader<u8, LLDRL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LLDRL` writer - Low-Byte Data Register Bits"]
pub struct LLDRL_W<'a> {
    w: &'a mut W,
}
impl<'a> LLDRL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: LLDRL_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Calibration limit for fast process corner/high output voltage"]
    #[inline(always)]
    pub fn calibration_limit_for_fast_process_corner_high_output_voltage(self) -> &'a mut W {
        self.variant(LLDRL_A::CALIBRATION_LIMIT_FOR_FAST_PROCESS_CORNER_HIGH_OUTPUT_VOLTAGE)
    }
    #[doc = "Calibration limit for slow process corner/low output voltage"]
    #[inline(always)]
    pub fn calibration_limit_for_slow_process_corner_low_output_voltage(self) -> &'a mut W {
        self.variant(LLDRL_A::CALIBRATION_LIMIT_FOR_SLOW_PROCESS_CORNER_LOW_OUTPUT_VOLTAGE)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u8 & 0x0f);
        self.w
    }
}
#[doc = "Field `Res` reader - Reserved"]
pub struct RES_R(crate::FieldReader<u8, u8>);
impl RES_R {
    pub(crate) fn new(bits: u8) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u8 & 0x0f) << 4);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:3 - Low-Byte Data Register Bits"]
    #[inline(always)]
    pub fn lldrl(&self) -> LLDRL_R {
        LLDRL_R::new((self.bits & 0x0f) as u8)
    }
    #[doc = "Bits 4:7 - Reserved"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
}
impl W {
    #[doc = "Bits 0:3 - Low-Byte Data Register Bits"]
    #[inline(always)]
    pub fn lldrl(&mut self) -> LLDRL_W {
        LLDRL_W { w: self }
    }
    #[doc = "Bits 4:7 - Reserved"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Low Leakage Voltage Regulator Data Register (Low-Byte)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [lldrl](index.html) module"]
pub struct LLDRL_SPEC;
impl crate::RegisterSpec for LLDRL_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [lldrl::R](R) reader structure"]
impl crate::Readable for LLDRL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [lldrl::W](W) writer structure"]
impl crate::Writable for LLDRL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LLDRL to value 0"]
impl crate::Resettable for LLDRL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
