#[doc = "Register `LLCR` reader"]
pub struct R(crate::R<LLCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LLCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<LLCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<LLCR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LLCR` writer"]
pub struct W(crate::W<LLCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LLCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<LLCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<LLCR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `LLENCAL` reader - Enable Automatic Calibration"]
pub struct LLENCAL_R(crate::FieldReader<bool, bool>);
impl LLENCAL_R {
    pub(crate) fn new(bits: bool) -> Self {
        LLENCAL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LLENCAL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LLENCAL` writer - Enable Automatic Calibration"]
pub struct LLENCAL_W<'a> {
    w: &'a mut W,
}
impl<'a> LLENCAL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `LLSHORT` reader - Short Lower Calibration Circuit"]
pub struct LLSHORT_R(crate::FieldReader<bool, bool>);
impl LLSHORT_R {
    pub(crate) fn new(bits: bool) -> Self {
        LLSHORT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LLSHORT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LLSHORT` writer - Short Lower Calibration Circuit"]
pub struct LLSHORT_W<'a> {
    w: &'a mut W,
}
impl<'a> LLSHORT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `LLTCO` reader - Temperature Coefficient of Current Source"]
pub struct LLTCO_R(crate::FieldReader<bool, bool>);
impl LLTCO_R {
    pub(crate) fn new(bits: bool) -> Self {
        LLTCO_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LLTCO_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LLTCO` writer - Temperature Coefficient of Current Source"]
pub struct LLTCO_W<'a> {
    w: &'a mut W,
}
impl<'a> LLTCO_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `LLCAL` reader - Calibration Active"]
pub struct LLCAL_R(crate::FieldReader<bool, bool>);
impl LLCAL_R {
    pub(crate) fn new(bits: bool) -> Self {
        LLCAL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LLCAL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LLCAL` writer - Calibration Active"]
pub struct LLCAL_W<'a> {
    w: &'a mut W,
}
impl<'a> LLCAL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `LLCOMP` reader - Comparator Output"]
pub struct LLCOMP_R(crate::FieldReader<bool, bool>);
impl LLCOMP_R {
    pub(crate) fn new(bits: bool) -> Self {
        LLCOMP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LLCOMP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LLCOMP` writer - Comparator Output"]
pub struct LLCOMP_W<'a> {
    w: &'a mut W,
}
impl<'a> LLCOMP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `LLDONE` reader - Calibration Done"]
pub struct LLDONE_R(crate::FieldReader<bool, bool>);
impl LLDONE_R {
    pub(crate) fn new(bits: bool) -> Self {
        LLDONE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LLDONE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LLDONE` writer - Calibration Done"]
pub struct LLDONE_W<'a> {
    w: &'a mut W,
}
impl<'a> LLDONE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `Res` reader - Reserved Bit"]
pub struct RES_R(crate::FieldReader<u8, u8>);
impl RES_R {
    pub(crate) fn new(bits: u8) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved Bit"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Enable Automatic Calibration"]
    #[inline(always)]
    pub fn llencal(&self) -> LLENCAL_R {
        LLENCAL_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Short Lower Calibration Circuit"]
    #[inline(always)]
    pub fn llshort(&self) -> LLSHORT_R {
        LLSHORT_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Temperature Coefficient of Current Source"]
    #[inline(always)]
    pub fn lltco(&self) -> LLTCO_R {
        LLTCO_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Calibration Active"]
    #[inline(always)]
    pub fn llcal(&self) -> LLCAL_R {
        LLCAL_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Comparator Output"]
    #[inline(always)]
    pub fn llcomp(&self) -> LLCOMP_R {
        LLCOMP_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Calibration Done"]
    #[inline(always)]
    pub fn lldone(&self) -> LLDONE_R {
        LLDONE_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bits 6:7 - Reserved Bit"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - Enable Automatic Calibration"]
    #[inline(always)]
    pub fn llencal(&mut self) -> LLENCAL_W {
        LLENCAL_W { w: self }
    }
    #[doc = "Bit 1 - Short Lower Calibration Circuit"]
    #[inline(always)]
    pub fn llshort(&mut self) -> LLSHORT_W {
        LLSHORT_W { w: self }
    }
    #[doc = "Bit 2 - Temperature Coefficient of Current Source"]
    #[inline(always)]
    pub fn lltco(&mut self) -> LLTCO_W {
        LLTCO_W { w: self }
    }
    #[doc = "Bit 3 - Calibration Active"]
    #[inline(always)]
    pub fn llcal(&mut self) -> LLCAL_W {
        LLCAL_W { w: self }
    }
    #[doc = "Bit 4 - Comparator Output"]
    #[inline(always)]
    pub fn llcomp(&mut self) -> LLCOMP_W {
        LLCOMP_W { w: self }
    }
    #[doc = "Bit 5 - Calibration Done"]
    #[inline(always)]
    pub fn lldone(&mut self) -> LLDONE_W {
        LLDONE_W { w: self }
    }
    #[doc = "Bits 6:7 - Reserved Bit"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Low Leakage Voltage Regulator Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [llcr](index.html) module"]
pub struct LLCR_SPEC;
impl crate::RegisterSpec for LLCR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [llcr::R](R) reader structure"]
impl crate::Readable for LLCR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [llcr::W](W) writer structure"]
impl crate::Writable for LLCR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LLCR to value 0"]
impl crate::Resettable for LLCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
