#[doc = "Register `DRTRAM2` reader"]
pub struct R(crate::R<DRTRAM2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DRTRAM2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DRTRAM2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DRTRAM2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DRTRAM2` writer"]
pub struct W(crate::W<DRTRAM2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DRTRAM2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DRTRAM2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DRTRAM2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ENDRT` reader - Enable SRAM Data Retention"]
pub struct ENDRT_R(crate::FieldReader<bool, bool>);
impl ENDRT_R {
    pub(crate) fn new(bits: bool) -> Self {
        ENDRT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ENDRT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ENDRT` writer - Enable SRAM Data Retention"]
pub struct ENDRT_W<'a> {
    w: &'a mut W,
}
impl<'a> ENDRT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `DRTSWOK` reader - DRT Switch OK"]
pub struct DRTSWOK_R(crate::FieldReader<bool, bool>);
impl DRTSWOK_R {
    pub(crate) fn new(bits: bool) -> Self {
        DRTSWOK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DRTSWOK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DRTSWOK` writer - DRT Switch OK"]
pub struct DRTSWOK_W<'a> {
    w: &'a mut W,
}
impl<'a> DRTSWOK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `Res` reader - Reserved Bit"]
pub struct RES_R(crate::FieldReader<bool, bool>);
impl RES_R {
    pub(crate) fn new(bits: bool) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved Bit"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 4 - Enable SRAM Data Retention"]
    #[inline(always)]
    pub fn endrt(&self) -> ENDRT_R {
        ENDRT_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - DRT Switch OK"]
    #[inline(always)]
    pub fn drtswok(&self) -> DRTSWOK_R {
        DRTSWOK_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Reserved Bit"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new(((self.bits >> 6) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 4 - Enable SRAM Data Retention"]
    #[inline(always)]
    pub fn endrt(&mut self) -> ENDRT_W {
        ENDRT_W { w: self }
    }
    #[doc = "Bit 5 - DRT Switch OK"]
    #[inline(always)]
    pub fn drtswok(&mut self) -> DRTSWOK_W {
        DRTSWOK_W { w: self }
    }
    #[doc = "Bit 6 - Reserved Bit"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Data Retention Configuration Register of SRAM 2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [drtram2](index.html) module"]
pub struct DRTRAM2_SPEC;
impl crate::RegisterSpec for DRTRAM2_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [drtram2::R](R) reader structure"]
impl crate::Readable for DRTRAM2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [drtram2::W](W) writer structure"]
impl crate::Writable for DRTRAM2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DRTRAM2 to value 0"]
impl crate::Resettable for DRTRAM2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
