#[doc = "Register `DPDS0` reader"]
pub struct R(crate::R<DPDS0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DPDS0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DPDS0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DPDS0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DPDS0` writer"]
pub struct W(crate::W<DPDS0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DPDS0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DPDS0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DPDS0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Driver Strength Port B\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum PBDRV_A {
    #[doc = "0: 2 mA"]
    PAD_IO_2MA = 0,
    #[doc = "1: 4 mA"]
    PAD_IO_4MA = 1,
    #[doc = "2: 6 mA"]
    PAD_IO_6MA = 2,
    #[doc = "3: 8 mA"]
    PAD_IO_8MA = 3,
}
impl From<PBDRV_A> for u8 {
    #[inline(always)]
    fn from(variant: PBDRV_A) -> Self {
        variant as _
    }
}
#[doc = "Field `PBDRV` reader - Driver Strength Port B"]
pub struct PBDRV_R(crate::FieldReader<u8, PBDRV_A>);
impl PBDRV_R {
    pub(crate) fn new(bits: u8) -> Self {
        PBDRV_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> PBDRV_A {
        match self.bits {
            0 => PBDRV_A::PAD_IO_2MA,
            1 => PBDRV_A::PAD_IO_4MA,
            2 => PBDRV_A::PAD_IO_6MA,
            3 => PBDRV_A::PAD_IO_8MA,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `PAD_IO_2MA`"]
    #[inline(always)]
    pub fn is_pad_io_2ma(&self) -> bool {
        **self == PBDRV_A::PAD_IO_2MA
    }
    #[doc = "Checks if the value of the field is `PAD_IO_4MA`"]
    #[inline(always)]
    pub fn is_pad_io_4ma(&self) -> bool {
        **self == PBDRV_A::PAD_IO_4MA
    }
    #[doc = "Checks if the value of the field is `PAD_IO_6MA`"]
    #[inline(always)]
    pub fn is_pad_io_6ma(&self) -> bool {
        **self == PBDRV_A::PAD_IO_6MA
    }
    #[doc = "Checks if the value of the field is `PAD_IO_8MA`"]
    #[inline(always)]
    pub fn is_pad_io_8ma(&self) -> bool {
        **self == PBDRV_A::PAD_IO_8MA
    }
}
impl core::ops::Deref for PBDRV_R {
    type Target = crate::FieldReader<u8, PBDRV_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PBDRV` writer - Driver Strength Port B"]
pub struct PBDRV_W<'a> {
    w: &'a mut W,
}
impl<'a> PBDRV_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PBDRV_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "2 mA"]
    #[inline(always)]
    pub fn pad_io_2ma(self) -> &'a mut W {
        self.variant(PBDRV_A::PAD_IO_2MA)
    }
    #[doc = "4 mA"]
    #[inline(always)]
    pub fn pad_io_4ma(self) -> &'a mut W {
        self.variant(PBDRV_A::PAD_IO_4MA)
    }
    #[doc = "6 mA"]
    #[inline(always)]
    pub fn pad_io_6ma(self) -> &'a mut W {
        self.variant(PBDRV_A::PAD_IO_6MA)
    }
    #[doc = "8 mA"]
    #[inline(always)]
    pub fn pad_io_8ma(self) -> &'a mut W {
        self.variant(PBDRV_A::PAD_IO_8MA)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Driver Strength Port D\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum PDDRV_A {
    #[doc = "0: 2 mA"]
    PAD_IO_2MA = 0,
    #[doc = "1: 4 mA"]
    PAD_IO_4MA = 1,
    #[doc = "2: 6 mA"]
    PAD_IO_6MA = 2,
    #[doc = "3: 8 mA"]
    PAD_IO_8MA = 3,
}
impl From<PDDRV_A> for u8 {
    #[inline(always)]
    fn from(variant: PDDRV_A) -> Self {
        variant as _
    }
}
#[doc = "Field `PDDRV` reader - Driver Strength Port D"]
pub struct PDDRV_R(crate::FieldReader<u8, PDDRV_A>);
impl PDDRV_R {
    pub(crate) fn new(bits: u8) -> Self {
        PDDRV_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> PDDRV_A {
        match self.bits {
            0 => PDDRV_A::PAD_IO_2MA,
            1 => PDDRV_A::PAD_IO_4MA,
            2 => PDDRV_A::PAD_IO_6MA,
            3 => PDDRV_A::PAD_IO_8MA,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `PAD_IO_2MA`"]
    #[inline(always)]
    pub fn is_pad_io_2ma(&self) -> bool {
        **self == PDDRV_A::PAD_IO_2MA
    }
    #[doc = "Checks if the value of the field is `PAD_IO_4MA`"]
    #[inline(always)]
    pub fn is_pad_io_4ma(&self) -> bool {
        **self == PDDRV_A::PAD_IO_4MA
    }
    #[doc = "Checks if the value of the field is `PAD_IO_6MA`"]
    #[inline(always)]
    pub fn is_pad_io_6ma(&self) -> bool {
        **self == PDDRV_A::PAD_IO_6MA
    }
    #[doc = "Checks if the value of the field is `PAD_IO_8MA`"]
    #[inline(always)]
    pub fn is_pad_io_8ma(&self) -> bool {
        **self == PDDRV_A::PAD_IO_8MA
    }
}
impl core::ops::Deref for PDDRV_R {
    type Target = crate::FieldReader<u8, PDDRV_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PDDRV` writer - Driver Strength Port D"]
pub struct PDDRV_W<'a> {
    w: &'a mut W,
}
impl<'a> PDDRV_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PDDRV_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "2 mA"]
    #[inline(always)]
    pub fn pad_io_2ma(self) -> &'a mut W {
        self.variant(PDDRV_A::PAD_IO_2MA)
    }
    #[doc = "4 mA"]
    #[inline(always)]
    pub fn pad_io_4ma(self) -> &'a mut W {
        self.variant(PDDRV_A::PAD_IO_4MA)
    }
    #[doc = "6 mA"]
    #[inline(always)]
    pub fn pad_io_6ma(self) -> &'a mut W {
        self.variant(PDDRV_A::PAD_IO_6MA)
    }
    #[doc = "8 mA"]
    #[inline(always)]
    pub fn pad_io_8ma(self) -> &'a mut W {
        self.variant(PDDRV_A::PAD_IO_8MA)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u8 & 0x03) << 2);
        self.w
    }
}
#[doc = "Driver Strength Port E\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum PEDRV_A {
    #[doc = "0: 2 mA"]
    PAD_IO_2MA = 0,
    #[doc = "1: 4 mA"]
    PAD_IO_4MA = 1,
    #[doc = "2: 6 mA"]
    PAD_IO_6MA = 2,
    #[doc = "3: 8 mA"]
    PAD_IO_8MA = 3,
}
impl From<PEDRV_A> for u8 {
    #[inline(always)]
    fn from(variant: PEDRV_A) -> Self {
        variant as _
    }
}
#[doc = "Field `PEDRV` reader - Driver Strength Port E"]
pub struct PEDRV_R(crate::FieldReader<u8, PEDRV_A>);
impl PEDRV_R {
    pub(crate) fn new(bits: u8) -> Self {
        PEDRV_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> PEDRV_A {
        match self.bits {
            0 => PEDRV_A::PAD_IO_2MA,
            1 => PEDRV_A::PAD_IO_4MA,
            2 => PEDRV_A::PAD_IO_6MA,
            3 => PEDRV_A::PAD_IO_8MA,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `PAD_IO_2MA`"]
    #[inline(always)]
    pub fn is_pad_io_2ma(&self) -> bool {
        **self == PEDRV_A::PAD_IO_2MA
    }
    #[doc = "Checks if the value of the field is `PAD_IO_4MA`"]
    #[inline(always)]
    pub fn is_pad_io_4ma(&self) -> bool {
        **self == PEDRV_A::PAD_IO_4MA
    }
    #[doc = "Checks if the value of the field is `PAD_IO_6MA`"]
    #[inline(always)]
    pub fn is_pad_io_6ma(&self) -> bool {
        **self == PEDRV_A::PAD_IO_6MA
    }
    #[doc = "Checks if the value of the field is `PAD_IO_8MA`"]
    #[inline(always)]
    pub fn is_pad_io_8ma(&self) -> bool {
        **self == PEDRV_A::PAD_IO_8MA
    }
}
impl core::ops::Deref for PEDRV_R {
    type Target = crate::FieldReader<u8, PEDRV_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PEDRV` writer - Driver Strength Port E"]
pub struct PEDRV_W<'a> {
    w: &'a mut W,
}
impl<'a> PEDRV_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PEDRV_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "2 mA"]
    #[inline(always)]
    pub fn pad_io_2ma(self) -> &'a mut W {
        self.variant(PEDRV_A::PAD_IO_2MA)
    }
    #[doc = "4 mA"]
    #[inline(always)]
    pub fn pad_io_4ma(self) -> &'a mut W {
        self.variant(PEDRV_A::PAD_IO_4MA)
    }
    #[doc = "6 mA"]
    #[inline(always)]
    pub fn pad_io_6ma(self) -> &'a mut W {
        self.variant(PEDRV_A::PAD_IO_6MA)
    }
    #[doc = "8 mA"]
    #[inline(always)]
    pub fn pad_io_8ma(self) -> &'a mut W {
        self.variant(PEDRV_A::PAD_IO_8MA)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Driver Strength Port F\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum PFDRV_A {
    #[doc = "0: 2 mA"]
    PAD_IO_2MA = 0,
    #[doc = "1: 4 mA"]
    PAD_IO_4MA = 1,
    #[doc = "2: 6 mA"]
    PAD_IO_6MA = 2,
    #[doc = "3: 8 mA"]
    PAD_IO_8MA = 3,
}
impl From<PFDRV_A> for u8 {
    #[inline(always)]
    fn from(variant: PFDRV_A) -> Self {
        variant as _
    }
}
#[doc = "Field `PFDRV` reader - Driver Strength Port F"]
pub struct PFDRV_R(crate::FieldReader<u8, PFDRV_A>);
impl PFDRV_R {
    pub(crate) fn new(bits: u8) -> Self {
        PFDRV_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> PFDRV_A {
        match self.bits {
            0 => PFDRV_A::PAD_IO_2MA,
            1 => PFDRV_A::PAD_IO_4MA,
            2 => PFDRV_A::PAD_IO_6MA,
            3 => PFDRV_A::PAD_IO_8MA,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `PAD_IO_2MA`"]
    #[inline(always)]
    pub fn is_pad_io_2ma(&self) -> bool {
        **self == PFDRV_A::PAD_IO_2MA
    }
    #[doc = "Checks if the value of the field is `PAD_IO_4MA`"]
    #[inline(always)]
    pub fn is_pad_io_4ma(&self) -> bool {
        **self == PFDRV_A::PAD_IO_4MA
    }
    #[doc = "Checks if the value of the field is `PAD_IO_6MA`"]
    #[inline(always)]
    pub fn is_pad_io_6ma(&self) -> bool {
        **self == PFDRV_A::PAD_IO_6MA
    }
    #[doc = "Checks if the value of the field is `PAD_IO_8MA`"]
    #[inline(always)]
    pub fn is_pad_io_8ma(&self) -> bool {
        **self == PFDRV_A::PAD_IO_8MA
    }
}
impl core::ops::Deref for PFDRV_R {
    type Target = crate::FieldReader<u8, PFDRV_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PFDRV` writer - Driver Strength Port F"]
pub struct PFDRV_W<'a> {
    w: &'a mut W,
}
impl<'a> PFDRV_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PFDRV_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "2 mA"]
    #[inline(always)]
    pub fn pad_io_2ma(self) -> &'a mut W {
        self.variant(PFDRV_A::PAD_IO_2MA)
    }
    #[doc = "4 mA"]
    #[inline(always)]
    pub fn pad_io_4ma(self) -> &'a mut W {
        self.variant(PFDRV_A::PAD_IO_4MA)
    }
    #[doc = "6 mA"]
    #[inline(always)]
    pub fn pad_io_6ma(self) -> &'a mut W {
        self.variant(PFDRV_A::PAD_IO_6MA)
    }
    #[doc = "8 mA"]
    #[inline(always)]
    pub fn pad_io_8ma(self) -> &'a mut W {
        self.variant(PFDRV_A::PAD_IO_8MA)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Driver Strength Port B"]
    #[inline(always)]
    pub fn pbdrv(&self) -> PBDRV_R {
        PBDRV_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - Driver Strength Port D"]
    #[inline(always)]
    pub fn pddrv(&self) -> PDDRV_R {
        PDDRV_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 4:5 - Driver Strength Port E"]
    #[inline(always)]
    pub fn pedrv(&self) -> PEDRV_R {
        PEDRV_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 6:7 - Driver Strength Port F"]
    #[inline(always)]
    pub fn pfdrv(&self) -> PFDRV_R {
        PFDRV_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:1 - Driver Strength Port B"]
    #[inline(always)]
    pub fn pbdrv(&mut self) -> PBDRV_W {
        PBDRV_W { w: self }
    }
    #[doc = "Bits 2:3 - Driver Strength Port D"]
    #[inline(always)]
    pub fn pddrv(&mut self) -> PDDRV_W {
        PDDRV_W { w: self }
    }
    #[doc = "Bits 4:5 - Driver Strength Port E"]
    #[inline(always)]
    pub fn pedrv(&mut self) -> PEDRV_W {
        PEDRV_W { w: self }
    }
    #[doc = "Bits 6:7 - Driver Strength Port F"]
    #[inline(always)]
    pub fn pfdrv(&mut self) -> PFDRV_W {
        PFDRV_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Port Driver Strength Register 0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [dpds0](index.html) module"]
pub struct DPDS0_SPEC;
impl crate::RegisterSpec for DPDS0_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [dpds0::R](R) reader structure"]
impl crate::Readable for DPDS0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [dpds0::W](W) writer structure"]
impl crate::Writable for DPDS0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DPDS0 to value 0"]
impl crate::Resettable for DPDS0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
