#[doc = r"Enumeration of all the interrupts."]
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
#[repr(u16)]
pub enum Interrupt {
    #[doc = "0 - External Pin,Power-on Reset,Brown-out Reset,Watchdog Reset,and JTAG AVR Reset. See Datasheet."]
    RESET = 0,
    #[doc = "1 - External Interrupt Request 0"]
    INT0 = 1,
    #[doc = "2 - External Interrupt Request 1"]
    INT1 = 2,
    #[doc = "3 - External Interrupt Request 2"]
    INT2 = 3,
    #[doc = "4 - External Interrupt Request 3"]
    INT3 = 4,
    #[doc = "5 - External Interrupt Request 4"]
    INT4 = 5,
    #[doc = "6 - External Interrupt Request 5"]
    INT5 = 6,
    #[doc = "7 - External Interrupt Request 6"]
    INT6 = 7,
    #[doc = "8 - External Interrupt Request 7"]
    INT7 = 8,
    #[doc = "9 - Pin Change Interrupt Request 0"]
    PCINT0 = 9,
    #[doc = "10 - Pin Change Interrupt Request 1"]
    PCINT1 = 10,
    #[doc = "11 - Pin Change Interrupt Request 2"]
    PCINT2 = 11,
    #[doc = "12 - Watchdog Time-out Interrupt"]
    WDT = 12,
    #[doc = "13 - Timer/Counter2 Compare Match A"]
    TIMER2_COMPA = 13,
    #[doc = "14 - Timer/Counter2 Compare Match B"]
    TIMER2_COMPB = 14,
    #[doc = "15 - Timer/Counter2 Overflow"]
    TIMER2_OVF = 15,
    #[doc = "16 - Timer/Counter1 Capture Event"]
    TIMER1_CAPT = 16,
    #[doc = "17 - Timer/Counter1 Compare Match A"]
    TIMER1_COMPA = 17,
    #[doc = "18 - Timer/Counter1 Compare Match B"]
    TIMER1_COMPB = 18,
    #[doc = "19 - Timer/Counter1 Compare Match C"]
    TIMER1_COMPC = 19,
    #[doc = "20 - Timer/Counter1 Overflow"]
    TIMER1_OVF = 20,
    #[doc = "21 - Timer/Counter0 Compare Match A"]
    TIMER0_COMPA = 21,
    #[doc = "22 - Timer/Counter0 Compare Match B"]
    TIMER0_COMPB = 22,
    #[doc = "23 - Timer/Counter0 Overflow"]
    TIMER0_OVF = 23,
    #[doc = "24 - SPI Serial Transfer Complete"]
    SPI_STC = 24,
    #[doc = "25 - USART0, Rx Complete"]
    USART0_RX = 25,
    #[doc = "26 - USART0 Data register Empty"]
    USART0_UDRE = 26,
    #[doc = "27 - USART0, Tx Complete"]
    USART0_TX = 27,
    #[doc = "28 - Analog Comparator"]
    ANALOG_COMP = 28,
    #[doc = "29 - ADC Conversion Complete"]
    ADC = 29,
    #[doc = "30 - EEPROM Ready"]
    EE_READY = 30,
    #[doc = "31 - Timer/Counter3 Capture Event"]
    TIMER3_CAPT = 31,
    #[doc = "32 - Timer/Counter3 Compare Match A"]
    TIMER3_COMPA = 32,
    #[doc = "33 - Timer/Counter3 Compare Match B"]
    TIMER3_COMPB = 33,
    #[doc = "34 - Timer/Counter3 Compare Match C"]
    TIMER3_COMPC = 34,
    #[doc = "35 - Timer/Counter3 Overflow"]
    TIMER3_OVF = 35,
    #[doc = "36 - USART1, Rx Complete"]
    USART1_RX = 36,
    #[doc = "37 - USART1 Data register Empty"]
    USART1_UDRE = 37,
    #[doc = "38 - USART1, Tx Complete"]
    USART1_TX = 38,
    #[doc = "39 - 2-wire Serial Interface"]
    TWI = 39,
    #[doc = "40 - Store Program Memory Read"]
    SPM_READY = 40,
    #[doc = "41 - Timer/Counter4 Capture Event"]
    TIMER4_CAPT = 41,
    #[doc = "42 - Timer/Counter4 Compare Match A"]
    TIMER4_COMPA = 42,
    #[doc = "43 - Timer/Counter4 Compare Match B"]
    TIMER4_COMPB = 43,
    #[doc = "44 - Timer/Counter4 Compare Match C"]
    TIMER4_COMPC = 44,
    #[doc = "45 - Timer/Counter4 Overflow"]
    TIMER4_OVF = 45,
    #[doc = "46 - Timer/Counter5 Capture Event"]
    TIMER5_CAPT = 46,
    #[doc = "47 - Timer/Counter5 Compare Match A"]
    TIMER5_COMPA = 47,
    #[doc = "48 - Timer/Counter5 Compare Match B"]
    TIMER5_COMPB = 48,
    #[doc = "49 - Timer/Counter5 Compare Match C"]
    TIMER5_COMPC = 49,
    #[doc = "50 - Timer/Counter5 Overflow"]
    TIMER5_OVF = 50,
    #[doc = "51 - USART2, Rx Complete"]
    USART2_RX = 51,
    #[doc = "52 - USART2 Data register Empty"]
    USART2_UDRE = 52,
    #[doc = "53 - USART2, Tx Complete"]
    USART2_TX = 53,
    #[doc = "54 - USART3, Rx Complete"]
    USART3_RX = 54,
    #[doc = "55 - USART3 Data register Empty"]
    USART3_UDRE = 55,
    #[doc = "56 - USART3, Tx Complete"]
    USART3_TX = 56,
    #[doc = "57 - TRX24 - PLL lock interrupt"]
    TRX24_PLL_LOCK = 57,
    #[doc = "58 - TRX24 - PLL unlock interrupt"]
    TRX24_PLL_UNLOCK = 58,
    #[doc = "59 - TRX24 - Receive start interrupt"]
    TRX24_RX_START = 59,
    #[doc = "60 - TRX24 - RX_END interrupt"]
    TRX24_RX_END = 60,
    #[doc = "61 - TRX24 - CCA/ED done interrupt"]
    TRX24_CCA_ED_DONE = 61,
    #[doc = "62 - TRX24 - XAH - AMI"]
    TRX24_XAH_AMI = 62,
    #[doc = "63 - TRX24 - TX_END interrupt"]
    TRX24_TX_END = 63,
    #[doc = "64 - TRX24 AWAKE - tranceiver is reaching state TRX_OFF"]
    TRX24_AWAKE = 64,
    #[doc = "65 - Symbol counter - compare match 1 interrupt"]
    SCNT_CMP1 = 65,
    #[doc = "66 - Symbol counter - compare match 2 interrupt"]
    SCNT_CMP2 = 66,
    #[doc = "67 - Symbol counter - compare match 3 interrupt"]
    SCNT_CMP3 = 67,
    #[doc = "68 - Symbol counter - overflow interrupt"]
    SCNT_OVFL = 68,
    #[doc = "69 - Symbol counter - backoff interrupt"]
    SCNT_BACKOFF = 69,
    #[doc = "70 - AES engine ready interrupt"]
    AES_READY = 70,
    #[doc = "71 - Battery monitor indicates supply voltage below threshold"]
    BAT_LOW = 71,
}
#[derive(Debug, Copy, Clone)]
pub struct TryFromInterruptError(());
impl Interrupt {
    #[inline]
    pub fn try_from(value: u8) -> Result<Self, TryFromInterruptError> {
        match value {
            0 => Ok(Interrupt::RESET),
            1 => Ok(Interrupt::INT0),
            2 => Ok(Interrupt::INT1),
            3 => Ok(Interrupt::INT2),
            4 => Ok(Interrupt::INT3),
            5 => Ok(Interrupt::INT4),
            6 => Ok(Interrupt::INT5),
            7 => Ok(Interrupt::INT6),
            8 => Ok(Interrupt::INT7),
            9 => Ok(Interrupt::PCINT0),
            10 => Ok(Interrupt::PCINT1),
            11 => Ok(Interrupt::PCINT2),
            12 => Ok(Interrupt::WDT),
            13 => Ok(Interrupt::TIMER2_COMPA),
            14 => Ok(Interrupt::TIMER2_COMPB),
            15 => Ok(Interrupt::TIMER2_OVF),
            16 => Ok(Interrupt::TIMER1_CAPT),
            17 => Ok(Interrupt::TIMER1_COMPA),
            18 => Ok(Interrupt::TIMER1_COMPB),
            19 => Ok(Interrupt::TIMER1_COMPC),
            20 => Ok(Interrupt::TIMER1_OVF),
            21 => Ok(Interrupt::TIMER0_COMPA),
            22 => Ok(Interrupt::TIMER0_COMPB),
            23 => Ok(Interrupt::TIMER0_OVF),
            24 => Ok(Interrupt::SPI_STC),
            25 => Ok(Interrupt::USART0_RX),
            26 => Ok(Interrupt::USART0_UDRE),
            27 => Ok(Interrupt::USART0_TX),
            28 => Ok(Interrupt::ANALOG_COMP),
            29 => Ok(Interrupt::ADC),
            30 => Ok(Interrupt::EE_READY),
            31 => Ok(Interrupt::TIMER3_CAPT),
            32 => Ok(Interrupt::TIMER3_COMPA),
            33 => Ok(Interrupt::TIMER3_COMPB),
            34 => Ok(Interrupt::TIMER3_COMPC),
            35 => Ok(Interrupt::TIMER3_OVF),
            36 => Ok(Interrupt::USART1_RX),
            37 => Ok(Interrupt::USART1_UDRE),
            38 => Ok(Interrupt::USART1_TX),
            39 => Ok(Interrupt::TWI),
            40 => Ok(Interrupt::SPM_READY),
            41 => Ok(Interrupt::TIMER4_CAPT),
            42 => Ok(Interrupt::TIMER4_COMPA),
            43 => Ok(Interrupt::TIMER4_COMPB),
            44 => Ok(Interrupt::TIMER4_COMPC),
            45 => Ok(Interrupt::TIMER4_OVF),
            46 => Ok(Interrupt::TIMER5_CAPT),
            47 => Ok(Interrupt::TIMER5_COMPA),
            48 => Ok(Interrupt::TIMER5_COMPB),
            49 => Ok(Interrupt::TIMER5_COMPC),
            50 => Ok(Interrupt::TIMER5_OVF),
            51 => Ok(Interrupt::USART2_RX),
            52 => Ok(Interrupt::USART2_UDRE),
            53 => Ok(Interrupt::USART2_TX),
            54 => Ok(Interrupt::USART3_RX),
            55 => Ok(Interrupt::USART3_UDRE),
            56 => Ok(Interrupt::USART3_TX),
            57 => Ok(Interrupt::TRX24_PLL_LOCK),
            58 => Ok(Interrupt::TRX24_PLL_UNLOCK),
            59 => Ok(Interrupt::TRX24_RX_START),
            60 => Ok(Interrupt::TRX24_RX_END),
            61 => Ok(Interrupt::TRX24_CCA_ED_DONE),
            62 => Ok(Interrupt::TRX24_XAH_AMI),
            63 => Ok(Interrupt::TRX24_TX_END),
            64 => Ok(Interrupt::TRX24_AWAKE),
            65 => Ok(Interrupt::SCNT_CMP1),
            66 => Ok(Interrupt::SCNT_CMP2),
            67 => Ok(Interrupt::SCNT_CMP3),
            68 => Ok(Interrupt::SCNT_OVFL),
            69 => Ok(Interrupt::SCNT_BACKOFF),
            70 => Ok(Interrupt::AES_READY),
            71 => Ok(Interrupt::BAT_LOW),
            _ => Err(TryFromInterruptError(())),
        }
    }
}
