#[doc = "Register `NEMCR` reader"]
pub struct R(crate::R<NEMCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<NEMCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<NEMCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<NEMCR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `NEMCR` writer"]
pub struct W(crate::W<NEMCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<NEMCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<NEMCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<NEMCR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Address for Extended Address Mode of Extra Rows\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum AEAM_A {
    #[doc = "0: Factory Row"]
    FACTORY_ROW = 0,
    #[doc = "1: User Row 1"]
    USER_ROW_1 = 1,
    #[doc = "2: User Row 2"]
    USER_ROW_2 = 2,
    #[doc = "3: User Row 3"]
    USER_ROW_3 = 3,
}
impl From<AEAM_A> for u8 {
    #[inline(always)]
    fn from(variant: AEAM_A) -> Self {
        variant as _
    }
}
#[doc = "Field `AEAM` reader - Address for Extended Address Mode of Extra Rows"]
pub struct AEAM_R(crate::FieldReader<u8, AEAM_A>);
impl AEAM_R {
    pub(crate) fn new(bits: u8) -> Self {
        AEAM_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> AEAM_A {
        match self.bits {
            0 => AEAM_A::FACTORY_ROW,
            1 => AEAM_A::USER_ROW_1,
            2 => AEAM_A::USER_ROW_2,
            3 => AEAM_A::USER_ROW_3,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `FACTORY_ROW`"]
    #[inline(always)]
    pub fn is_factory_row(&self) -> bool {
        **self == AEAM_A::FACTORY_ROW
    }
    #[doc = "Checks if the value of the field is `USER_ROW_1`"]
    #[inline(always)]
    pub fn is_user_row_1(&self) -> bool {
        **self == AEAM_A::USER_ROW_1
    }
    #[doc = "Checks if the value of the field is `USER_ROW_2`"]
    #[inline(always)]
    pub fn is_user_row_2(&self) -> bool {
        **self == AEAM_A::USER_ROW_2
    }
    #[doc = "Checks if the value of the field is `USER_ROW_3`"]
    #[inline(always)]
    pub fn is_user_row_3(&self) -> bool {
        **self == AEAM_A::USER_ROW_3
    }
}
impl core::ops::Deref for AEAM_R {
    type Target = crate::FieldReader<u8, AEAM_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AEAM` writer - Address for Extended Address Mode of Extra Rows"]
pub struct AEAM_W<'a> {
    w: &'a mut W,
}
impl<'a> AEAM_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: AEAM_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Factory Row"]
    #[inline(always)]
    pub fn factory_row(self) -> &'a mut W {
        self.variant(AEAM_A::FACTORY_ROW)
    }
    #[doc = "User Row 1"]
    #[inline(always)]
    pub fn user_row_1(self) -> &'a mut W {
        self.variant(AEAM_A::USER_ROW_1)
    }
    #[doc = "User Row 2"]
    #[inline(always)]
    pub fn user_row_2(self) -> &'a mut W {
        self.variant(AEAM_A::USER_ROW_2)
    }
    #[doc = "User Row 3"]
    #[inline(always)]
    pub fn user_row_3(self) -> &'a mut W {
        self.variant(AEAM_A::USER_ROW_3)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `ENEAM` reader - Enable Extended Address Mode for Extra Rows"]
pub struct ENEAM_R(crate::FieldReader<bool, bool>);
impl ENEAM_R {
    pub(crate) fn new(bits: bool) -> Self {
        ENEAM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ENEAM_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ENEAM` writer - Enable Extended Address Mode for Extra Rows"]
pub struct ENEAM_W<'a> {
    w: &'a mut W,
}
impl<'a> ENEAM_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bits 4:5 - Address for Extended Address Mode of Extra Rows"]
    #[inline(always)]
    pub fn aeam(&self) -> AEAM_R {
        AEAM_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bit 6 - Enable Extended Address Mode for Extra Rows"]
    #[inline(always)]
    pub fn eneam(&self) -> ENEAM_R {
        ENEAM_R::new(((self.bits >> 6) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 4:5 - Address for Extended Address Mode of Extra Rows"]
    #[inline(always)]
    pub fn aeam(&mut self) -> AEAM_W {
        AEAM_W { w: self }
    }
    #[doc = "Bit 6 - Enable Extended Address Mode for Extra Rows"]
    #[inline(always)]
    pub fn eneam(&mut self) -> ENEAM_W {
        ENEAM_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Flash Extended-Mode Control-Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [nemcr](index.html) module"]
pub struct NEMCR_SPEC;
impl crate::RegisterSpec for NEMCR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [nemcr::R](R) reader structure"]
impl crate::Readable for NEMCR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [nemcr::W](W) writer structure"]
impl crate::Writable for NEMCR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets NEMCR to value 0"]
impl crate::Resettable for NEMCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
