#[doc = "Register `PCIFR` reader"]
pub struct R(crate::R<PCIFR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PCIFR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PCIFR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PCIFR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PCIFR` writer"]
pub struct W(crate::W<PCIFR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PCIFR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PCIFR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PCIFR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PCIF` reader - Pin Change Interrupt Flags"]
pub struct PCIF_R(crate::FieldReader<u8, u8>);
impl PCIF_R {
    pub(crate) fn new(bits: u8) -> Self {
        PCIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCIF_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCIF` writer - Pin Change Interrupt Flags"]
pub struct PCIF_W<'a> {
    w: &'a mut W,
}
impl<'a> PCIF_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `Res` reader - Reserved Bit"]
pub struct RES_R(crate::FieldReader<u8, u8>);
impl RES_R {
    pub(crate) fn new(bits: u8) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved Bit"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 3)) | ((value as u8 & 0x1f) << 3);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Pin Change Interrupt Flags"]
    #[inline(always)]
    pub fn pcif(&self) -> PCIF_R {
        PCIF_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bits 3:7 - Reserved Bit"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new(((self.bits >> 3) & 0x1f) as u8)
    }
}
impl W {
    #[doc = "Bits 0:2 - Pin Change Interrupt Flags"]
    #[inline(always)]
    pub fn pcif(&mut self) -> PCIF_W {
        PCIF_W { w: self }
    }
    #[doc = "Bits 3:7 - Reserved Bit"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Pin Change Interrupt Flag Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pcifr](index.html) module"]
pub struct PCIFR_SPEC;
impl crate::RegisterSpec for PCIFR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [pcifr::R](R) reader structure"]
impl crate::Readable for PCIFR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [pcifr::W](W) writer structure"]
impl crate::Writable for PCIFR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PCIFR to value 0"]
impl crate::Resettable for PCIFR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
