#[doc = "Register `PCICR` reader"]
pub struct R(crate::R<PCICR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PCICR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PCICR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PCICR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PCICR` writer"]
pub struct W(crate::W<PCICR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PCICR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PCICR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PCICR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PCIE` reader - Pin Change Interrupt Enables"]
pub struct PCIE_R(crate::FieldReader<u8, u8>);
impl PCIE_R {
    pub(crate) fn new(bits: u8) -> Self {
        PCIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCIE_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCIE` writer - Pin Change Interrupt Enables"]
pub struct PCIE_W<'a> {
    w: &'a mut W,
}
impl<'a> PCIE_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `Res` reader - Reserved Bit"]
pub struct RES_R(crate::FieldReader<u8, u8>);
impl RES_R {
    pub(crate) fn new(bits: u8) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved Bit"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 3)) | ((value as u8 & 0x1f) << 3);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Pin Change Interrupt Enables"]
    #[inline(always)]
    pub fn pcie(&self) -> PCIE_R {
        PCIE_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bits 3:7 - Reserved Bit"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new(((self.bits >> 3) & 0x1f) as u8)
    }
}
impl W {
    #[doc = "Bits 0:2 - Pin Change Interrupt Enables"]
    #[inline(always)]
    pub fn pcie(&mut self) -> PCIE_W {
        PCIE_W { w: self }
    }
    #[doc = "Bits 3:7 - Reserved Bit"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Pin Change Interrupt Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pcicr](index.html) module"]
pub struct PCICR_SPEC;
impl crate::RegisterSpec for PCICR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [pcicr::R](R) reader structure"]
impl crate::Readable for PCICR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [pcicr::W](W) writer structure"]
impl crate::Writable for PCICR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PCICR to value 0"]
impl crate::Resettable for PCICR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
