#[doc = "Register `GPIOR2` reader"]
pub struct R(crate::R<GPIOR2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GPIOR2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GPIOR2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GPIOR2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GPIOR2` writer"]
pub struct W(crate::W<GPIOR2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GPIOR2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GPIOR2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GPIOR2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `GPIOR` reader - General Purpose I/O Register 2 Value"]
pub struct GPIOR_R(crate::FieldReader<u8, u8>);
impl GPIOR_R {
    pub(crate) fn new(bits: u8) -> Self {
        GPIOR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GPIOR_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GPIOR` writer - General Purpose I/O Register 2 Value"]
pub struct GPIOR_W<'a> {
    w: &'a mut W,
}
impl<'a> GPIOR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - General Purpose I/O Register 2 Value"]
    #[inline(always)]
    pub fn gpior(&self) -> GPIOR_R {
        GPIOR_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - General Purpose I/O Register 2 Value"]
    #[inline(always)]
    pub fn gpior(&mut self) -> GPIOR_W {
        GPIOR_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "General Purpose I/O Register 2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gpior2](index.html) module"]
pub struct GPIOR2_SPEC;
impl crate::RegisterSpec for GPIOR2_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [gpior2::R](R) reader structure"]
impl crate::Readable for GPIOR2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gpior2::W](W) writer structure"]
impl crate::Writable for GPIOR2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GPIOR2 to value 0"]
impl crate::Resettable for GPIOR2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
