#[doc = "Register `DIDR2` reader"]
pub struct R(crate::R<DIDR2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DIDR2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DIDR2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DIDR2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DIDR2` writer"]
pub struct W(crate::W<DIDR2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DIDR2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DIDR2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DIDR2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ADC8D` reader - Reserved Bits"]
pub struct ADC8D_R(crate::FieldReader<bool, bool>);
impl ADC8D_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC8D_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC8D_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC8D` writer - Reserved Bits"]
pub struct ADC8D_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC8D_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `ADC9D` reader - Reserved Bits"]
pub struct ADC9D_R(crate::FieldReader<bool, bool>);
impl ADC9D_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC9D_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC9D_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC9D` writer - Reserved Bits"]
pub struct ADC9D_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC9D_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `ADC10D` reader - Reserved Bits"]
pub struct ADC10D_R(crate::FieldReader<bool, bool>);
impl ADC10D_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC10D_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC10D_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC10D` writer - Reserved Bits"]
pub struct ADC10D_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC10D_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `ADC11D` reader - Reserved Bits"]
pub struct ADC11D_R(crate::FieldReader<bool, bool>);
impl ADC11D_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC11D_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC11D_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC11D` writer - Reserved Bits"]
pub struct ADC11D_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC11D_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `ADC12D` reader - Reserved Bits"]
pub struct ADC12D_R(crate::FieldReader<bool, bool>);
impl ADC12D_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC12D_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC12D_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC12D` writer - Reserved Bits"]
pub struct ADC12D_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC12D_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `ADC13D` reader - Reserved Bits"]
pub struct ADC13D_R(crate::FieldReader<bool, bool>);
impl ADC13D_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC13D_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC13D_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC13D` writer - Reserved Bits"]
pub struct ADC13D_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC13D_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `ADC14D` reader - Reserved Bits"]
pub struct ADC14D_R(crate::FieldReader<bool, bool>);
impl ADC14D_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC14D_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC14D_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC14D` writer - Reserved Bits"]
pub struct ADC14D_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC14D_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `ADC15D` reader - Reserved Bits"]
pub struct ADC15D_R(crate::FieldReader<bool, bool>);
impl ADC15D_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC15D_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC15D_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC15D` writer - Reserved Bits"]
pub struct ADC15D_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC15D_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Reserved Bits"]
    #[inline(always)]
    pub fn adc8d(&self) -> ADC8D_R {
        ADC8D_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Reserved Bits"]
    #[inline(always)]
    pub fn adc9d(&self) -> ADC9D_R {
        ADC9D_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Reserved Bits"]
    #[inline(always)]
    pub fn adc10d(&self) -> ADC10D_R {
        ADC10D_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Reserved Bits"]
    #[inline(always)]
    pub fn adc11d(&self) -> ADC11D_R {
        ADC11D_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Reserved Bits"]
    #[inline(always)]
    pub fn adc12d(&self) -> ADC12D_R {
        ADC12D_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Reserved Bits"]
    #[inline(always)]
    pub fn adc13d(&self) -> ADC13D_R {
        ADC13D_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Reserved Bits"]
    #[inline(always)]
    pub fn adc14d(&self) -> ADC14D_R {
        ADC14D_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Reserved Bits"]
    #[inline(always)]
    pub fn adc15d(&self) -> ADC15D_R {
        ADC15D_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Reserved Bits"]
    #[inline(always)]
    pub fn adc8d(&mut self) -> ADC8D_W {
        ADC8D_W { w: self }
    }
    #[doc = "Bit 1 - Reserved Bits"]
    #[inline(always)]
    pub fn adc9d(&mut self) -> ADC9D_W {
        ADC9D_W { w: self }
    }
    #[doc = "Bit 2 - Reserved Bits"]
    #[inline(always)]
    pub fn adc10d(&mut self) -> ADC10D_W {
        ADC10D_W { w: self }
    }
    #[doc = "Bit 3 - Reserved Bits"]
    #[inline(always)]
    pub fn adc11d(&mut self) -> ADC11D_W {
        ADC11D_W { w: self }
    }
    #[doc = "Bit 4 - Reserved Bits"]
    #[inline(always)]
    pub fn adc12d(&mut self) -> ADC12D_W {
        ADC12D_W { w: self }
    }
    #[doc = "Bit 5 - Reserved Bits"]
    #[inline(always)]
    pub fn adc13d(&mut self) -> ADC13D_W {
        ADC13D_W { w: self }
    }
    #[doc = "Bit 6 - Reserved Bits"]
    #[inline(always)]
    pub fn adc14d(&mut self) -> ADC14D_W {
        ADC14D_W { w: self }
    }
    #[doc = "Bit 7 - Reserved Bits"]
    #[inline(always)]
    pub fn adc15d(&mut self) -> ADC15D_W {
        ADC15D_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Digital Input Disable Register 2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [didr2](index.html) module"]
pub struct DIDR2_SPEC;
impl crate::RegisterSpec for DIDR2_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [didr2::R](R) reader structure"]
impl crate::Readable for DIDR2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [didr2::W](W) writer structure"]
impl crate::Writable for DIDR2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DIDR2 to value 0"]
impl crate::Resettable for DIDR2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
