#[doc = "Register `ADCSRB` reader"]
pub struct R(crate::R<ADCSRB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ADCSRB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ADCSRB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ADCSRB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ADCSRB` writer"]
pub struct W(crate::W<ADCSRB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ADCSRB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ADCSRB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ADCSRB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "ADC Auto Trigger Source\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum ADTS_A {
    #[doc = "0: Free Running mode"]
    FREE_RUNNING_MODE = 0,
    #[doc = "1: Analog Comparator"]
    ANALOG_COMPARATOR = 1,
    #[doc = "2: External Interrupt Request 0"]
    EXTERNAL_INTERRUPT_REQUEST_0 = 2,
    #[doc = "3: Timer/Counter0 Compare Match A"]
    TIMER_COUNTER0_COMPARE_MATCH_A = 3,
    #[doc = "4: Timer/Counter0 Overflow"]
    TIMER_COUNTER0_OVERFLOW = 4,
    #[doc = "5: Timer/Counter1 Compare Match B"]
    TIMER_COUNTER1_COMPARE_MATCH_B = 5,
    #[doc = "6: Timer/Counter1 Overflow"]
    TIMER_COUNTER1_OVERFLOW = 6,
    #[doc = "7: Timer/Counter1 Capture Event"]
    TIMER_COUNTER1_CAPTURE_EVENT = 7,
}
impl From<ADTS_A> for u8 {
    #[inline(always)]
    fn from(variant: ADTS_A) -> Self {
        variant as _
    }
}
#[doc = "Field `ADTS` reader - ADC Auto Trigger Source"]
pub struct ADTS_R(crate::FieldReader<u8, ADTS_A>);
impl ADTS_R {
    pub(crate) fn new(bits: u8) -> Self {
        ADTS_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> ADTS_A {
        match self.bits {
            0 => ADTS_A::FREE_RUNNING_MODE,
            1 => ADTS_A::ANALOG_COMPARATOR,
            2 => ADTS_A::EXTERNAL_INTERRUPT_REQUEST_0,
            3 => ADTS_A::TIMER_COUNTER0_COMPARE_MATCH_A,
            4 => ADTS_A::TIMER_COUNTER0_OVERFLOW,
            5 => ADTS_A::TIMER_COUNTER1_COMPARE_MATCH_B,
            6 => ADTS_A::TIMER_COUNTER1_OVERFLOW,
            7 => ADTS_A::TIMER_COUNTER1_CAPTURE_EVENT,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `FREE_RUNNING_MODE`"]
    #[inline(always)]
    pub fn is_free_running_mode(&self) -> bool {
        **self == ADTS_A::FREE_RUNNING_MODE
    }
    #[doc = "Checks if the value of the field is `ANALOG_COMPARATOR`"]
    #[inline(always)]
    pub fn is_analog_comparator(&self) -> bool {
        **self == ADTS_A::ANALOG_COMPARATOR
    }
    #[doc = "Checks if the value of the field is `EXTERNAL_INTERRUPT_REQUEST_0`"]
    #[inline(always)]
    pub fn is_external_interrupt_request_0(&self) -> bool {
        **self == ADTS_A::EXTERNAL_INTERRUPT_REQUEST_0
    }
    #[doc = "Checks if the value of the field is `TIMER_COUNTER0_COMPARE_MATCH_A`"]
    #[inline(always)]
    pub fn is_timer_counter0_compare_match_a(&self) -> bool {
        **self == ADTS_A::TIMER_COUNTER0_COMPARE_MATCH_A
    }
    #[doc = "Checks if the value of the field is `TIMER_COUNTER0_OVERFLOW`"]
    #[inline(always)]
    pub fn is_timer_counter0_overflow(&self) -> bool {
        **self == ADTS_A::TIMER_COUNTER0_OVERFLOW
    }
    #[doc = "Checks if the value of the field is `TIMER_COUNTER1_COMPARE_MATCH_B`"]
    #[inline(always)]
    pub fn is_timer_counter1_compare_match_b(&self) -> bool {
        **self == ADTS_A::TIMER_COUNTER1_COMPARE_MATCH_B
    }
    #[doc = "Checks if the value of the field is `TIMER_COUNTER1_OVERFLOW`"]
    #[inline(always)]
    pub fn is_timer_counter1_overflow(&self) -> bool {
        **self == ADTS_A::TIMER_COUNTER1_OVERFLOW
    }
    #[doc = "Checks if the value of the field is `TIMER_COUNTER1_CAPTURE_EVENT`"]
    #[inline(always)]
    pub fn is_timer_counter1_capture_event(&self) -> bool {
        **self == ADTS_A::TIMER_COUNTER1_CAPTURE_EVENT
    }
}
impl core::ops::Deref for ADTS_R {
    type Target = crate::FieldReader<u8, ADTS_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADTS` writer - ADC Auto Trigger Source"]
pub struct ADTS_W<'a> {
    w: &'a mut W,
}
impl<'a> ADTS_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: ADTS_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Free Running mode"]
    #[inline(always)]
    pub fn free_running_mode(self) -> &'a mut W {
        self.variant(ADTS_A::FREE_RUNNING_MODE)
    }
    #[doc = "Analog Comparator"]
    #[inline(always)]
    pub fn analog_comparator(self) -> &'a mut W {
        self.variant(ADTS_A::ANALOG_COMPARATOR)
    }
    #[doc = "External Interrupt Request 0"]
    #[inline(always)]
    pub fn external_interrupt_request_0(self) -> &'a mut W {
        self.variant(ADTS_A::EXTERNAL_INTERRUPT_REQUEST_0)
    }
    #[doc = "Timer/Counter0 Compare Match A"]
    #[inline(always)]
    pub fn timer_counter0_compare_match_a(self) -> &'a mut W {
        self.variant(ADTS_A::TIMER_COUNTER0_COMPARE_MATCH_A)
    }
    #[doc = "Timer/Counter0 Overflow"]
    #[inline(always)]
    pub fn timer_counter0_overflow(self) -> &'a mut W {
        self.variant(ADTS_A::TIMER_COUNTER0_OVERFLOW)
    }
    #[doc = "Timer/Counter1 Compare Match B"]
    #[inline(always)]
    pub fn timer_counter1_compare_match_b(self) -> &'a mut W {
        self.variant(ADTS_A::TIMER_COUNTER1_COMPARE_MATCH_B)
    }
    #[doc = "Timer/Counter1 Overflow"]
    #[inline(always)]
    pub fn timer_counter1_overflow(self) -> &'a mut W {
        self.variant(ADTS_A::TIMER_COUNTER1_OVERFLOW)
    }
    #[doc = "Timer/Counter1 Capture Event"]
    #[inline(always)]
    pub fn timer_counter1_capture_event(self) -> &'a mut W {
        self.variant(ADTS_A::TIMER_COUNTER1_CAPTURE_EVENT)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `MUX5` reader - Analog Channel and Gain Selection Bits"]
pub struct MUX5_R(crate::FieldReader<bool, bool>);
impl MUX5_R {
    pub(crate) fn new(bits: bool) -> Self {
        MUX5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MUX5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MUX5` writer - Analog Channel and Gain Selection Bits"]
pub struct MUX5_W<'a> {
    w: &'a mut W,
}
impl<'a> MUX5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `ACCH` reader - Analog Channel Change"]
pub struct ACCH_R(crate::FieldReader<bool, bool>);
impl ACCH_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACCH_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACCH_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACCH` writer - Analog Channel Change"]
pub struct ACCH_W<'a> {
    w: &'a mut W,
}
impl<'a> ACCH_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `REFOK` reader - Reference Voltage OK"]
pub struct REFOK_R(crate::FieldReader<bool, bool>);
impl REFOK_R {
    pub(crate) fn new(bits: bool) -> Self {
        REFOK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REFOK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `REFOK` writer - Reference Voltage OK"]
pub struct REFOK_W<'a> {
    w: &'a mut W,
}
impl<'a> REFOK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `ACME` reader - Analog Comparator Multiplexer Enable"]
pub struct ACME_R(crate::FieldReader<bool, bool>);
impl ACME_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACME_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACME_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACME` writer - Analog Comparator Multiplexer Enable"]
pub struct ACME_W<'a> {
    w: &'a mut W,
}
impl<'a> ACME_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `AVDDOK` reader - AVDD Supply Voltage OK"]
pub struct AVDDOK_R(crate::FieldReader<bool, bool>);
impl AVDDOK_R {
    pub(crate) fn new(bits: bool) -> Self {
        AVDDOK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AVDDOK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AVDDOK` writer - AVDD Supply Voltage OK"]
pub struct AVDDOK_W<'a> {
    w: &'a mut W,
}
impl<'a> AVDDOK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - ADC Auto Trigger Source"]
    #[inline(always)]
    pub fn adts(&self) -> ADTS_R {
        ADTS_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bit 3 - Analog Channel and Gain Selection Bits"]
    #[inline(always)]
    pub fn mux5(&self) -> MUX5_R {
        MUX5_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Analog Channel Change"]
    #[inline(always)]
    pub fn acch(&self) -> ACCH_R {
        ACCH_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Reference Voltage OK"]
    #[inline(always)]
    pub fn refok(&self) -> REFOK_R {
        REFOK_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Analog Comparator Multiplexer Enable"]
    #[inline(always)]
    pub fn acme(&self) -> ACME_R {
        ACME_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - AVDD Supply Voltage OK"]
    #[inline(always)]
    pub fn avddok(&self) -> AVDDOK_R {
        AVDDOK_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - ADC Auto Trigger Source"]
    #[inline(always)]
    pub fn adts(&mut self) -> ADTS_W {
        ADTS_W { w: self }
    }
    #[doc = "Bit 3 - Analog Channel and Gain Selection Bits"]
    #[inline(always)]
    pub fn mux5(&mut self) -> MUX5_W {
        MUX5_W { w: self }
    }
    #[doc = "Bit 4 - Analog Channel Change"]
    #[inline(always)]
    pub fn acch(&mut self) -> ACCH_W {
        ACCH_W { w: self }
    }
    #[doc = "Bit 5 - Reference Voltage OK"]
    #[inline(always)]
    pub fn refok(&mut self) -> REFOK_W {
        REFOK_W { w: self }
    }
    #[doc = "Bit 6 - Analog Comparator Multiplexer Enable"]
    #[inline(always)]
    pub fn acme(&mut self) -> ACME_W {
        ACME_W { w: self }
    }
    #[doc = "Bit 7 - AVDD Supply Voltage OK"]
    #[inline(always)]
    pub fn avddok(&mut self) -> AVDDOK_W {
        AVDDOK_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "The ADC Control and Status Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [adcsrb](index.html) module"]
pub struct ADCSRB_SPEC;
impl crate::RegisterSpec for ADCSRB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [adcsrb::R](R) reader structure"]
impl crate::Readable for ADCSRB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [adcsrb::W](W) writer structure"]
impl crate::Writable for ADCSRB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ADCSRB to value 0"]
impl crate::Resettable for ADCSRB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
