#[doc = "Register `UDR1` reader"]
pub struct R(crate::R<UDR1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UDR1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UDR1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UDR1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UDR1` writer"]
pub struct W(crate::W<UDR1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UDR1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UDR1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UDR1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `UDR1` reader - USART I/O Data bits"]
pub struct UDR1_R(crate::FieldReader<u8, u8>);
impl UDR1_R {
    pub(crate) fn new(bits: u8) -> Self {
        UDR1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UDR1_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UDR1` writer - USART I/O Data bits"]
pub struct UDR1_W<'a> {
    w: &'a mut W,
}
impl<'a> UDR1_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - USART I/O Data bits"]
    #[inline(always)]
    pub fn udr1(&self) -> UDR1_R {
        UDR1_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - USART I/O Data bits"]
    #[inline(always)]
    pub fn udr1(&mut self) -> UDR1_W {
        UDR1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USART I/O Data Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [udr1](index.html) module"]
pub struct UDR1_SPEC;
impl crate::RegisterSpec for UDR1_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [udr1::R](R) reader structure"]
impl crate::Readable for UDR1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [udr1::W](W) writer structure"]
impl crate::Writable for UDR1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UDR1 to value 0"]
impl crate::Resettable for UDR1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
