#[doc = "Register `TWDR` reader"]
pub struct R(crate::R<TWDR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TWDR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TWDR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TWDR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TWDR` writer"]
pub struct W(crate::W<TWDR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TWDR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TWDR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TWDR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TWD` reader - TWI Data bits"]
pub struct TWD_R(crate::FieldReader<u8, u8>);
impl TWD_R {
    pub(crate) fn new(bits: u8) -> Self {
        TWD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWD_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWD` writer - TWI Data bits"]
pub struct TWD_W<'a> {
    w: &'a mut W,
}
impl<'a> TWD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - TWI Data bits"]
    #[inline(always)]
    pub fn twd(&self) -> TWD_R {
        TWD_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - TWI Data bits"]
    #[inline(always)]
    pub fn twd(&mut self) -> TWD_W {
        TWD_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "TWI Data register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [twdr](index.html) module"]
pub struct TWDR_SPEC;
impl crate::RegisterSpec for TWDR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [twdr::R](R) reader structure"]
impl crate::Readable for TWDR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [twdr::W](W) writer structure"]
impl crate::Writable for TWDR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TWDR to value 0"]
impl crate::Resettable for TWDR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
