#[doc = "Register `TWBR` reader"]
pub struct R(crate::R<TWBR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TWBR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TWBR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TWBR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TWBR` writer"]
pub struct W(crate::W<TWBR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TWBR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TWBR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TWBR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TWBR` reader - TWI Bit Rate bits"]
pub struct TWBR_R(crate::FieldReader<u8, u8>);
impl TWBR_R {
    pub(crate) fn new(bits: u8) -> Self {
        TWBR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWBR_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWBR` writer - TWI Bit Rate bits"]
pub struct TWBR_W<'a> {
    w: &'a mut W,
}
impl<'a> TWBR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - TWI Bit Rate bits"]
    #[inline(always)]
    pub fn twbr(&self) -> TWBR_R {
        TWBR_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - TWI Bit Rate bits"]
    #[inline(always)]
    pub fn twbr(&mut self) -> TWBR_W {
        TWBR_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "TWI Bit Rate register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [twbr](index.html) module"]
pub struct TWBR_SPEC;
impl crate::RegisterSpec for TWBR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [twbr::R](R) reader structure"]
impl crate::Readable for TWBR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [twbr::W](W) writer structure"]
impl crate::Writable for TWBR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TWBR to value 0"]
impl crate::Resettable for TWBR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
