#[doc = "Register `TCCR3A` reader"]
pub struct R(crate::R<TCCR3A_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR3A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR3A_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR3A_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR3A` writer"]
pub struct W(crate::W<TCCR3A_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR3A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR3A_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR3A_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `WGM3` reader - Pulse Width Modulator Select Bits"]
pub struct WGM3_R(crate::FieldReader<u8, u8>);
impl WGM3_R {
    pub(crate) fn new(bits: u8) -> Self {
        WGM3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WGM3_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM3` writer - Pulse Width Modulator Select Bits"]
pub struct WGM3_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM3_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Compare Output Mode 3B, bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum COM3B_A {
    #[doc = "0: Normal port operation, OCix disconnected"]
    DISCONNECTED = 0,
    #[doc = "1: Toggle OCix on Compare Match (Might depend on WGM)"]
    MATCH_TOGGLE = 1,
    #[doc = "2: Clear OCix on Compare Match (If PWM is enabled, OCix is set at BOTTOM)"]
    MATCH_CLEAR = 2,
    #[doc = "3: Set OCix on Compare Match (If PWM is enabled, OCix is cleared at BOTTOM)"]
    MATCH_SET = 3,
}
impl From<COM3B_A> for u8 {
    #[inline(always)]
    fn from(variant: COM3B_A) -> Self {
        variant as _
    }
}
#[doc = "Field `COM3B` reader - Compare Output Mode 3B, bits"]
pub struct COM3B_R(crate::FieldReader<u8, COM3B_A>);
impl COM3B_R {
    pub(crate) fn new(bits: u8) -> Self {
        COM3B_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> COM3B_A {
        match self.bits {
            0 => COM3B_A::DISCONNECTED,
            1 => COM3B_A::MATCH_TOGGLE,
            2 => COM3B_A::MATCH_CLEAR,
            3 => COM3B_A::MATCH_SET,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `DISCONNECTED`"]
    #[inline(always)]
    pub fn is_disconnected(&self) -> bool {
        **self == COM3B_A::DISCONNECTED
    }
    #[doc = "Checks if the value of the field is `MATCH_TOGGLE`"]
    #[inline(always)]
    pub fn is_match_toggle(&self) -> bool {
        **self == COM3B_A::MATCH_TOGGLE
    }
    #[doc = "Checks if the value of the field is `MATCH_CLEAR`"]
    #[inline(always)]
    pub fn is_match_clear(&self) -> bool {
        **self == COM3B_A::MATCH_CLEAR
    }
    #[doc = "Checks if the value of the field is `MATCH_SET`"]
    #[inline(always)]
    pub fn is_match_set(&self) -> bool {
        **self == COM3B_A::MATCH_SET
    }
}
impl core::ops::Deref for COM3B_R {
    type Target = crate::FieldReader<u8, COM3B_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COM3B` writer - Compare Output Mode 3B, bits"]
pub struct COM3B_W<'a> {
    w: &'a mut W,
}
impl<'a> COM3B_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: COM3B_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Normal port operation, OCix disconnected"]
    #[inline(always)]
    pub fn disconnected(self) -> &'a mut W {
        self.variant(COM3B_A::DISCONNECTED)
    }
    #[doc = "Toggle OCix on Compare Match (Might depend on WGM)"]
    #[inline(always)]
    pub fn match_toggle(self) -> &'a mut W {
        self.variant(COM3B_A::MATCH_TOGGLE)
    }
    #[doc = "Clear OCix on Compare Match (If PWM is enabled, OCix is set at BOTTOM)"]
    #[inline(always)]
    pub fn match_clear(self) -> &'a mut W {
        self.variant(COM3B_A::MATCH_CLEAR)
    }
    #[doc = "Set OCix on Compare Match (If PWM is enabled, OCix is cleared at BOTTOM)"]
    #[inline(always)]
    pub fn match_set(self) -> &'a mut W {
        self.variant(COM3B_A::MATCH_SET)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Compare Output Mode 3A, bits"]
pub type COM3A_A = COM3B_A;
#[doc = "Field `COM3A` reader - Compare Output Mode 3A, bits"]
pub type COM3A_R = COM3B_R;
#[doc = "Field `COM3A` writer - Compare Output Mode 3A, bits"]
pub struct COM3A_W<'a> {
    w: &'a mut W,
}
impl<'a> COM3A_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: COM3A_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Normal port operation, OCix disconnected"]
    #[inline(always)]
    pub fn disconnected(self) -> &'a mut W {
        self.variant(COM3A_A::DISCONNECTED)
    }
    #[doc = "Toggle OCix on Compare Match (Might depend on WGM)"]
    #[inline(always)]
    pub fn match_toggle(self) -> &'a mut W {
        self.variant(COM3A_A::MATCH_TOGGLE)
    }
    #[doc = "Clear OCix on Compare Match (If PWM is enabled, OCix is set at BOTTOM)"]
    #[inline(always)]
    pub fn match_clear(self) -> &'a mut W {
        self.variant(COM3A_A::MATCH_CLEAR)
    }
    #[doc = "Set OCix on Compare Match (If PWM is enabled, OCix is cleared at BOTTOM)"]
    #[inline(always)]
    pub fn match_set(self) -> &'a mut W {
        self.variant(COM3A_A::MATCH_SET)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Pulse Width Modulator Select Bits"]
    #[inline(always)]
    pub fn wgm3(&self) -> WGM3_R {
        WGM3_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 4:5 - Compare Output Mode 3B, bits"]
    #[inline(always)]
    pub fn com3b(&self) -> COM3B_R {
        COM3B_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 6:7 - Compare Output Mode 3A, bits"]
    #[inline(always)]
    pub fn com3a(&self) -> COM3A_R {
        COM3A_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:1 - Pulse Width Modulator Select Bits"]
    #[inline(always)]
    pub fn wgm3(&mut self) -> WGM3_W {
        WGM3_W { w: self }
    }
    #[doc = "Bits 4:5 - Compare Output Mode 3B, bits"]
    #[inline(always)]
    pub fn com3b(&mut self) -> COM3B_W {
        COM3B_W { w: self }
    }
    #[doc = "Bits 6:7 - Compare Output Mode 3A, bits"]
    #[inline(always)]
    pub fn com3a(&mut self) -> COM3A_W {
        COM3A_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter3 Control Register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr3a](index.html) module"]
pub struct TCCR3A_SPEC;
impl crate::RegisterSpec for TCCR3A_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr3a::R](R) reader structure"]
impl crate::Readable for TCCR3A_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr3a::W](W) writer structure"]
impl crate::Writable for TCCR3A_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR3A to value 0"]
impl crate::Resettable for TCCR3A_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
