#[doc = "Register `ASSR` reader"]
pub struct R(crate::R<ASSR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ASSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ASSR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ASSR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ASSR` writer"]
pub struct W(crate::W<ASSR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ASSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ASSR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ASSR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TCR2BUB` reader - Timer/Counter Control Register2 Update Busy"]
pub struct TCR2BUB_R(crate::FieldReader<bool, bool>);
impl TCR2BUB_R {
    pub(crate) fn new(bits: bool) -> Self {
        TCR2BUB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TCR2BUB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TCR2BUB` writer - Timer/Counter Control Register2 Update Busy"]
pub struct TCR2BUB_W<'a> {
    w: &'a mut W,
}
impl<'a> TCR2BUB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `TCR2AUB` reader - Timer/Counter Control Register2 Update Busy"]
pub struct TCR2AUB_R(crate::FieldReader<bool, bool>);
impl TCR2AUB_R {
    pub(crate) fn new(bits: bool) -> Self {
        TCR2AUB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TCR2AUB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TCR2AUB` writer - Timer/Counter Control Register2 Update Busy"]
pub struct TCR2AUB_W<'a> {
    w: &'a mut W,
}
impl<'a> TCR2AUB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `OCR2BUB` reader - Output Compare Register 2 Update Busy"]
pub struct OCR2BUB_R(crate::FieldReader<bool, bool>);
impl OCR2BUB_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCR2BUB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCR2BUB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCR2BUB` writer - Output Compare Register 2 Update Busy"]
pub struct OCR2BUB_W<'a> {
    w: &'a mut W,
}
impl<'a> OCR2BUB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `OCR2AUB` reader - Output Compare Register2 Update Busy"]
pub struct OCR2AUB_R(crate::FieldReader<bool, bool>);
impl OCR2AUB_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCR2AUB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCR2AUB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCR2AUB` writer - Output Compare Register2 Update Busy"]
pub struct OCR2AUB_W<'a> {
    w: &'a mut W,
}
impl<'a> OCR2AUB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `TCN2UB` reader - Timer/Counter2 Update Busy"]
pub struct TCN2UB_R(crate::FieldReader<bool, bool>);
impl TCN2UB_R {
    pub(crate) fn new(bits: bool) -> Self {
        TCN2UB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TCN2UB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TCN2UB` writer - Timer/Counter2 Update Busy"]
pub struct TCN2UB_W<'a> {
    w: &'a mut W,
}
impl<'a> TCN2UB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `AS2` reader - Asynchronous Timer/Counter2"]
pub struct AS2_R(crate::FieldReader<bool, bool>);
impl AS2_R {
    pub(crate) fn new(bits: bool) -> Self {
        AS2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AS2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AS2` writer - Asynchronous Timer/Counter2"]
pub struct AS2_W<'a> {
    w: &'a mut W,
}
impl<'a> AS2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `EXCLK` reader - Enable External Clock Input"]
pub struct EXCLK_R(crate::FieldReader<bool, bool>);
impl EXCLK_R {
    pub(crate) fn new(bits: bool) -> Self {
        EXCLK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXCLK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXCLK` writer - Enable External Clock Input"]
pub struct EXCLK_W<'a> {
    w: &'a mut W,
}
impl<'a> EXCLK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Timer/Counter Control Register2 Update Busy"]
    #[inline(always)]
    pub fn tcr2bub(&self) -> TCR2BUB_R {
        TCR2BUB_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Timer/Counter Control Register2 Update Busy"]
    #[inline(always)]
    pub fn tcr2aub(&self) -> TCR2AUB_R {
        TCR2AUB_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Output Compare Register 2 Update Busy"]
    #[inline(always)]
    pub fn ocr2bub(&self) -> OCR2BUB_R {
        OCR2BUB_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Output Compare Register2 Update Busy"]
    #[inline(always)]
    pub fn ocr2aub(&self) -> OCR2AUB_R {
        OCR2AUB_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Timer/Counter2 Update Busy"]
    #[inline(always)]
    pub fn tcn2ub(&self) -> TCN2UB_R {
        TCN2UB_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Asynchronous Timer/Counter2"]
    #[inline(always)]
    pub fn as2(&self) -> AS2_R {
        AS2_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Enable External Clock Input"]
    #[inline(always)]
    pub fn exclk(&self) -> EXCLK_R {
        EXCLK_R::new(((self.bits >> 6) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Timer/Counter Control Register2 Update Busy"]
    #[inline(always)]
    pub fn tcr2bub(&mut self) -> TCR2BUB_W {
        TCR2BUB_W { w: self }
    }
    #[doc = "Bit 1 - Timer/Counter Control Register2 Update Busy"]
    #[inline(always)]
    pub fn tcr2aub(&mut self) -> TCR2AUB_W {
        TCR2AUB_W { w: self }
    }
    #[doc = "Bit 2 - Output Compare Register 2 Update Busy"]
    #[inline(always)]
    pub fn ocr2bub(&mut self) -> OCR2BUB_W {
        OCR2BUB_W { w: self }
    }
    #[doc = "Bit 3 - Output Compare Register2 Update Busy"]
    #[inline(always)]
    pub fn ocr2aub(&mut self) -> OCR2AUB_W {
        OCR2AUB_W { w: self }
    }
    #[doc = "Bit 4 - Timer/Counter2 Update Busy"]
    #[inline(always)]
    pub fn tcn2ub(&mut self) -> TCN2UB_W {
        TCN2UB_W { w: self }
    }
    #[doc = "Bit 5 - Asynchronous Timer/Counter2"]
    #[inline(always)]
    pub fn as2(&mut self) -> AS2_W {
        AS2_W { w: self }
    }
    #[doc = "Bit 6 - Enable External Clock Input"]
    #[inline(always)]
    pub fn exclk(&mut self) -> EXCLK_W {
        EXCLK_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Asynchronous Status Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [assr](index.html) module"]
pub struct ASSR_SPEC;
impl crate::RegisterSpec for ASSR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [assr::R](R) reader structure"]
impl crate::Readable for ASSR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [assr::W](W) writer structure"]
impl crate::Writable for ASSR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ASSR to value 0"]
impl crate::Resettable for ASSR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
