#[doc = "Register `PCICR` reader"]
pub struct R(crate::R<PCICR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PCICR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PCICR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PCICR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PCICR` writer"]
pub struct W(crate::W<PCICR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PCICR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PCICR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PCICR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PCIE0` reader - Pin Change Interrupt Enable 0"]
pub struct PCIE0_R(crate::FieldReader<bool, bool>);
impl PCIE0_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCIE0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCIE0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCIE0` writer - Pin Change Interrupt Enable 0"]
pub struct PCIE0_W<'a> {
    w: &'a mut W,
}
impl<'a> PCIE0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `PCIE1` reader - Pin Change Interrupt Enable 1"]
pub struct PCIE1_R(crate::FieldReader<bool, bool>);
impl PCIE1_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCIE1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCIE1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCIE1` writer - Pin Change Interrupt Enable 1"]
pub struct PCIE1_W<'a> {
    w: &'a mut W,
}
impl<'a> PCIE1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `PCIE2` reader - Pin Change Interrupt Enable 2"]
pub struct PCIE2_R(crate::FieldReader<bool, bool>);
impl PCIE2_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCIE2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCIE2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCIE2` writer - Pin Change Interrupt Enable 2"]
pub struct PCIE2_W<'a> {
    w: &'a mut W,
}
impl<'a> PCIE2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `PCIE3` reader - Pin Change Interrupt Enable 3"]
pub struct PCIE3_R(crate::FieldReader<bool, bool>);
impl PCIE3_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCIE3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCIE3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCIE3` writer - Pin Change Interrupt Enable 3"]
pub struct PCIE3_W<'a> {
    w: &'a mut W,
}
impl<'a> PCIE3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Pin Change Interrupt Enable 0"]
    #[inline(always)]
    pub fn pcie0(&self) -> PCIE0_R {
        PCIE0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Pin Change Interrupt Enable 1"]
    #[inline(always)]
    pub fn pcie1(&self) -> PCIE1_R {
        PCIE1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Pin Change Interrupt Enable 2"]
    #[inline(always)]
    pub fn pcie2(&self) -> PCIE2_R {
        PCIE2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Pin Change Interrupt Enable 3"]
    #[inline(always)]
    pub fn pcie3(&self) -> PCIE3_R {
        PCIE3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Pin Change Interrupt Enable 0"]
    #[inline(always)]
    pub fn pcie0(&mut self) -> PCIE0_W {
        PCIE0_W { w: self }
    }
    #[doc = "Bit 1 - Pin Change Interrupt Enable 1"]
    #[inline(always)]
    pub fn pcie1(&mut self) -> PCIE1_W {
        PCIE1_W { w: self }
    }
    #[doc = "Bit 2 - Pin Change Interrupt Enable 2"]
    #[inline(always)]
    pub fn pcie2(&mut self) -> PCIE2_W {
        PCIE2_W { w: self }
    }
    #[doc = "Bit 3 - Pin Change Interrupt Enable 3"]
    #[inline(always)]
    pub fn pcie3(&mut self) -> PCIE3_W {
        PCIE3_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Pin Change Interrupt Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pcicr](index.html) module"]
pub struct PCICR_SPEC;
impl crate::RegisterSpec for PCICR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [pcicr::R](R) reader structure"]
impl crate::Readable for PCICR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [pcicr::W](W) writer structure"]
impl crate::Writable for PCICR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PCICR to value 0"]
impl crate::Resettable for PCICR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
