#[doc = "Register `EEDR` reader"]
pub struct R(crate::R<EEDR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EEDR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<EEDR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<EEDR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EEDR` writer"]
pub struct W(crate::W<EEDR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<EEDR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<EEDR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<EEDR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `EEDR` reader - EEPROM Data bits"]
pub struct EEDR_R(crate::FieldReader<u8, u8>);
impl EEDR_R {
    pub(crate) fn new(bits: u8) -> Self {
        EEDR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EEDR_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EEDR` writer - EEPROM Data bits"]
pub struct EEDR_W<'a> {
    w: &'a mut W,
}
impl<'a> EEDR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - EEPROM Data bits"]
    #[inline(always)]
    pub fn eedr(&self) -> EEDR_R {
        EEDR_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - EEPROM Data bits"]
    #[inline(always)]
    pub fn eedr(&mut self) -> EEDR_W {
        EEDR_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "EEPROM Data Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [eedr](index.html) module"]
pub struct EEDR_SPEC;
impl crate::RegisterSpec for EEDR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [eedr::R](R) reader structure"]
impl crate::Readable for EEDR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [eedr::W](W) writer structure"]
impl crate::Writable for EEDR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EEDR to value 0"]
impl crate::Resettable for EEDR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
