#[doc = "Register `EEAR` reader"]
pub struct R(crate::R<EEAR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EEAR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<EEAR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<EEAR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EEAR` writer"]
pub struct W(crate::W<EEAR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<EEAR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<EEAR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<EEAR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `EEAR` reader - EEPROM Address bits"]
pub struct EEAR_R(crate::FieldReader<u16, u16>);
impl EEAR_R {
    pub(crate) fn new(bits: u16) -> Self {
        EEAR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EEAR_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EEAR` writer - EEPROM Address bits"]
pub struct EEAR_W<'a> {
    w: &'a mut W,
}
impl<'a> EEAR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0fff) | (value as u16 & 0x0fff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:11 - EEPROM Address bits"]
    #[inline(always)]
    pub fn eear(&self) -> EEAR_R {
        EEAR_R::new((self.bits & 0x0fff) as u16)
    }
}
impl W {
    #[doc = "Bits 0:11 - EEPROM Address bits"]
    #[inline(always)]
    pub fn eear(&mut self) -> EEAR_W {
        EEAR_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u16) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "EEPROM Address Register Low Bytes\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [eear](index.html) module"]
pub struct EEAR_SPEC;
impl crate::RegisterSpec for EEAR_SPEC {
    type Ux = u16;
}
#[doc = "`read()` method returns [eear::R](R) reader structure"]
impl crate::Readable for EEAR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [eear::W](W) writer structure"]
impl crate::Writable for EEAR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EEAR to value 0"]
impl crate::Resettable for EEAR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
