#[doc = "Register `ADC` reader"]
pub struct R(crate::R<ADC_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ADC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ADC_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ADC_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ADC` writer"]
pub struct W(crate::W<ADC_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ADC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ADC_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ADC_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ADC` reader - ADC Data bits"]
pub struct ADC_R(crate::FieldReader<u16, u16>);
impl ADC_R {
    pub(crate) fn new(bits: u16) -> Self {
        ADC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC` writer - ADC Data bits"]
pub struct ADC_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xffff) | (value as u16 & 0xffff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:15 - ADC Data bits"]
    #[inline(always)]
    pub fn adc(&self) -> ADC_R {
        ADC_R::new((self.bits & 0xffff) as u16)
    }
}
impl W {
    #[doc = "Bits 0:15 - ADC Data bits"]
    #[inline(always)]
    pub fn adc(&mut self) -> ADC_W {
        ADC_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u16) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "ADC Data Register Bytes\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [adc](index.html) module"]
pub struct ADC_SPEC;
impl crate::RegisterSpec for ADC_SPEC {
    type Ux = u16;
}
#[doc = "`read()` method returns [adc::R](R) reader structure"]
impl crate::Readable for ADC_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [adc::W](W) writer structure"]
impl crate::Writable for ADC_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ADC to value 0"]
impl crate::Resettable for ADC_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
