#[doc = "Register `UCSR2B` reader"]
pub struct R(crate::R<UCSR2B_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UCSR2B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UCSR2B_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UCSR2B_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UCSR2B` writer"]
pub struct W(crate::W<UCSR2B_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UCSR2B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UCSR2B_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UCSR2B_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TXB82` reader - Transmit Data Bit 8"]
pub struct TXB82_R(crate::FieldReader<bool, bool>);
impl TXB82_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXB82_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXB82_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXB82` writer - Transmit Data Bit 8"]
pub struct TXB82_W<'a> {
    w: &'a mut W,
}
impl<'a> TXB82_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `RXB82` reader - Receive Data Bit 8"]
pub struct RXB82_R(crate::FieldReader<bool, bool>);
impl RXB82_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXB82_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXB82_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCSZ22` reader - Character Size"]
pub struct UCSZ22_R(crate::FieldReader<bool, bool>);
impl UCSZ22_R {
    pub(crate) fn new(bits: bool) -> Self {
        UCSZ22_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UCSZ22_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCSZ22` writer - Character Size"]
pub struct UCSZ22_W<'a> {
    w: &'a mut W,
}
impl<'a> UCSZ22_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `TXEN2` reader - Transmitter Enable"]
pub struct TXEN2_R(crate::FieldReader<bool, bool>);
impl TXEN2_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXEN2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXEN2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXEN2` writer - Transmitter Enable"]
pub struct TXEN2_W<'a> {
    w: &'a mut W,
}
impl<'a> TXEN2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `RXEN2` reader - Receiver Enable"]
pub struct RXEN2_R(crate::FieldReader<bool, bool>);
impl RXEN2_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXEN2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXEN2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXEN2` writer - Receiver Enable"]
pub struct RXEN2_W<'a> {
    w: &'a mut W,
}
impl<'a> RXEN2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `UDRIE2` reader - USART Data register Empty Interrupt Enable"]
pub struct UDRIE2_R(crate::FieldReader<bool, bool>);
impl UDRIE2_R {
    pub(crate) fn new(bits: bool) -> Self {
        UDRIE2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UDRIE2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UDRIE2` writer - USART Data register Empty Interrupt Enable"]
pub struct UDRIE2_W<'a> {
    w: &'a mut W,
}
impl<'a> UDRIE2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `TXCIE2` reader - TX Complete Interrupt Enable"]
pub struct TXCIE2_R(crate::FieldReader<bool, bool>);
impl TXCIE2_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXCIE2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXCIE2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXCIE2` writer - TX Complete Interrupt Enable"]
pub struct TXCIE2_W<'a> {
    w: &'a mut W,
}
impl<'a> TXCIE2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RXCIE2` reader - RX Complete Interrupt Enable"]
pub struct RXCIE2_R(crate::FieldReader<bool, bool>);
impl RXCIE2_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXCIE2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXCIE2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXCIE2` writer - RX Complete Interrupt Enable"]
pub struct RXCIE2_W<'a> {
    w: &'a mut W,
}
impl<'a> RXCIE2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Transmit Data Bit 8"]
    #[inline(always)]
    pub fn txb82(&self) -> TXB82_R {
        TXB82_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Receive Data Bit 8"]
    #[inline(always)]
    pub fn rxb82(&self) -> RXB82_R {
        RXB82_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Character Size"]
    #[inline(always)]
    pub fn ucsz22(&self) -> UCSZ22_R {
        UCSZ22_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Transmitter Enable"]
    #[inline(always)]
    pub fn txen2(&self) -> TXEN2_R {
        TXEN2_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Receiver Enable"]
    #[inline(always)]
    pub fn rxen2(&self) -> RXEN2_R {
        RXEN2_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - USART Data register Empty Interrupt Enable"]
    #[inline(always)]
    pub fn udrie2(&self) -> UDRIE2_R {
        UDRIE2_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - TX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn txcie2(&self) -> TXCIE2_R {
        TXCIE2_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - RX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn rxcie2(&self) -> RXCIE2_R {
        RXCIE2_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Transmit Data Bit 8"]
    #[inline(always)]
    pub fn txb82(&mut self) -> TXB82_W {
        TXB82_W { w: self }
    }
    #[doc = "Bit 2 - Character Size"]
    #[inline(always)]
    pub fn ucsz22(&mut self) -> UCSZ22_W {
        UCSZ22_W { w: self }
    }
    #[doc = "Bit 3 - Transmitter Enable"]
    #[inline(always)]
    pub fn txen2(&mut self) -> TXEN2_W {
        TXEN2_W { w: self }
    }
    #[doc = "Bit 4 - Receiver Enable"]
    #[inline(always)]
    pub fn rxen2(&mut self) -> RXEN2_W {
        RXEN2_W { w: self }
    }
    #[doc = "Bit 5 - USART Data register Empty Interrupt Enable"]
    #[inline(always)]
    pub fn udrie2(&mut self) -> UDRIE2_W {
        UDRIE2_W { w: self }
    }
    #[doc = "Bit 6 - TX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn txcie2(&mut self) -> TXCIE2_W {
        TXCIE2_W { w: self }
    }
    #[doc = "Bit 7 - RX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn rxcie2(&mut self) -> RXCIE2_W {
        RXCIE2_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USART Control and Status Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ucsr2b](index.html) module"]
pub struct UCSR2B_SPEC;
impl crate::RegisterSpec for UCSR2B_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ucsr2b::R](R) reader structure"]
impl crate::Readable for UCSR2B_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ucsr2b::W](W) writer structure"]
impl crate::Writable for UCSR2B_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UCSR2B to value 0"]
impl crate::Resettable for UCSR2B_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
