#[doc = "Register `UCSR0A` reader"]
pub struct R(crate::R<UCSR0A_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UCSR0A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UCSR0A_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UCSR0A_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UCSR0A` writer"]
pub struct W(crate::W<UCSR0A_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UCSR0A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UCSR0A_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UCSR0A_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `MPCM0` reader - Multi-processor Communication Mode"]
pub struct MPCM0_R(crate::FieldReader<bool, bool>);
impl MPCM0_R {
    pub(crate) fn new(bits: bool) -> Self {
        MPCM0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MPCM0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MPCM0` writer - Multi-processor Communication Mode"]
pub struct MPCM0_W<'a> {
    w: &'a mut W,
}
impl<'a> MPCM0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `U2X0` reader - Double the USART transmission speed"]
pub struct U2X0_R(crate::FieldReader<bool, bool>);
impl U2X0_R {
    pub(crate) fn new(bits: bool) -> Self {
        U2X0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for U2X0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `U2X0` writer - Double the USART transmission speed"]
pub struct U2X0_W<'a> {
    w: &'a mut W,
}
impl<'a> U2X0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `UPE0` reader - Parity Error"]
pub struct UPE0_R(crate::FieldReader<bool, bool>);
impl UPE0_R {
    pub(crate) fn new(bits: bool) -> Self {
        UPE0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UPE0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DOR0` reader - Data overRun"]
pub struct DOR0_R(crate::FieldReader<bool, bool>);
impl DOR0_R {
    pub(crate) fn new(bits: bool) -> Self {
        DOR0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DOR0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FE0` reader - Framing Error"]
pub struct FE0_R(crate::FieldReader<bool, bool>);
impl FE0_R {
    pub(crate) fn new(bits: bool) -> Self {
        FE0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FE0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UDRE0` reader - USART Data Register Empty"]
pub struct UDRE0_R(crate::FieldReader<bool, bool>);
impl UDRE0_R {
    pub(crate) fn new(bits: bool) -> Self {
        UDRE0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UDRE0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXC0` reader - USART Transmit Complete"]
pub struct TXC0_R(crate::FieldReader<bool, bool>);
impl TXC0_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXC0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXC0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXC0` writer - USART Transmit Complete"]
pub struct TXC0_W<'a> {
    w: &'a mut W,
}
impl<'a> TXC0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RXC0` reader - USART Receive Complete"]
pub struct RXC0_R(crate::FieldReader<bool, bool>);
impl RXC0_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXC0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXC0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bit 0 - Multi-processor Communication Mode"]
    #[inline(always)]
    pub fn mpcm0(&self) -> MPCM0_R {
        MPCM0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Double the USART transmission speed"]
    #[inline(always)]
    pub fn u2x0(&self) -> U2X0_R {
        U2X0_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Parity Error"]
    #[inline(always)]
    pub fn upe0(&self) -> UPE0_R {
        UPE0_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Data overRun"]
    #[inline(always)]
    pub fn dor0(&self) -> DOR0_R {
        DOR0_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Framing Error"]
    #[inline(always)]
    pub fn fe0(&self) -> FE0_R {
        FE0_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - USART Data Register Empty"]
    #[inline(always)]
    pub fn udre0(&self) -> UDRE0_R {
        UDRE0_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - USART Transmit Complete"]
    #[inline(always)]
    pub fn txc0(&self) -> TXC0_R {
        TXC0_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - USART Receive Complete"]
    #[inline(always)]
    pub fn rxc0(&self) -> RXC0_R {
        RXC0_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Multi-processor Communication Mode"]
    #[inline(always)]
    pub fn mpcm0(&mut self) -> MPCM0_W {
        MPCM0_W { w: self }
    }
    #[doc = "Bit 1 - Double the USART transmission speed"]
    #[inline(always)]
    pub fn u2x0(&mut self) -> U2X0_W {
        U2X0_W { w: self }
    }
    #[doc = "Bit 6 - USART Transmit Complete"]
    #[inline(always)]
    pub fn txc0(&mut self) -> TXC0_W {
        TXC0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USART Control and Status Register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ucsr0a](index.html) module"]
pub struct UCSR0A_SPEC;
impl crate::RegisterSpec for UCSR0A_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ucsr0a::R](R) reader structure"]
impl crate::Readable for UCSR0A_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ucsr0a::W](W) writer structure"]
impl crate::Writable for UCSR0A_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UCSR0A to value 0"]
impl crate::Resettable for UCSR0A_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
