#[doc = "Register `TCCR4A` reader"]
pub struct R(crate::R<TCCR4A_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR4A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR4A_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR4A_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR4A` writer"]
pub struct W(crate::W<TCCR4A_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR4A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR4A_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR4A_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `WGM4` reader - Waveform Generation Mode"]
pub struct WGM4_R(crate::FieldReader<u8, u8>);
impl WGM4_R {
    pub(crate) fn new(bits: u8) -> Self {
        WGM4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WGM4_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM4` writer - Waveform Generation Mode"]
pub struct WGM4_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM4_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `COM4C` reader - Compare Output Mode 4C, bits"]
pub struct COM4C_R(crate::FieldReader<u8, u8>);
impl COM4C_R {
    pub(crate) fn new(bits: u8) -> Self {
        COM4C_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for COM4C_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COM4C` writer - Compare Output Mode 4C, bits"]
pub struct COM4C_W<'a> {
    w: &'a mut W,
}
impl<'a> COM4C_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u8 & 0x03) << 2);
        self.w
    }
}
#[doc = "Field `COM4B` reader - Compare Output Mode 4B, bits"]
pub struct COM4B_R(crate::FieldReader<u8, u8>);
impl COM4B_R {
    pub(crate) fn new(bits: u8) -> Self {
        COM4B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for COM4B_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COM4B` writer - Compare Output Mode 4B, bits"]
pub struct COM4B_W<'a> {
    w: &'a mut W,
}
impl<'a> COM4B_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `COM4A` reader - Compare Output Mode 1A, bits"]
pub struct COM4A_R(crate::FieldReader<u8, u8>);
impl COM4A_R {
    pub(crate) fn new(bits: u8) -> Self {
        COM4A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for COM4A_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COM4A` writer - Compare Output Mode 1A, bits"]
pub struct COM4A_W<'a> {
    w: &'a mut W,
}
impl<'a> COM4A_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm4(&self) -> WGM4_R {
        WGM4_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - Compare Output Mode 4C, bits"]
    #[inline(always)]
    pub fn com4c(&self) -> COM4C_R {
        COM4C_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 4:5 - Compare Output Mode 4B, bits"]
    #[inline(always)]
    pub fn com4b(&self) -> COM4B_R {
        COM4B_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 6:7 - Compare Output Mode 1A, bits"]
    #[inline(always)]
    pub fn com4a(&self) -> COM4A_R {
        COM4A_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:1 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm4(&mut self) -> WGM4_W {
        WGM4_W { w: self }
    }
    #[doc = "Bits 2:3 - Compare Output Mode 4C, bits"]
    #[inline(always)]
    pub fn com4c(&mut self) -> COM4C_W {
        COM4C_W { w: self }
    }
    #[doc = "Bits 4:5 - Compare Output Mode 4B, bits"]
    #[inline(always)]
    pub fn com4b(&mut self) -> COM4B_W {
        COM4B_W { w: self }
    }
    #[doc = "Bits 6:7 - Compare Output Mode 1A, bits"]
    #[inline(always)]
    pub fn com4a(&mut self) -> COM4A_W {
        COM4A_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter4 Control Register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr4a](index.html) module"]
pub struct TCCR4A_SPEC;
impl crate::RegisterSpec for TCCR4A_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr4a::R](R) reader structure"]
impl crate::Readable for TCCR4A_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr4a::W](W) writer structure"]
impl crate::Writable for TCCR4A_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR4A to value 0"]
impl crate::Resettable for TCCR4A_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
