#[doc = "Register `TIMSK3` reader"]
pub struct R(crate::R<TIMSK3_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TIMSK3_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TIMSK3_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TIMSK3_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TIMSK3` writer"]
pub struct W(crate::W<TIMSK3_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TIMSK3_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TIMSK3_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TIMSK3_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TOIE3` reader - Timer/Counter3 Overflow Interrupt Enable"]
pub struct TOIE3_R(crate::FieldReader<bool, bool>);
impl TOIE3_R {
    pub(crate) fn new(bits: bool) -> Self {
        TOIE3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOIE3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOIE3` writer - Timer/Counter3 Overflow Interrupt Enable"]
pub struct TOIE3_W<'a> {
    w: &'a mut W,
}
impl<'a> TOIE3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `OCIE3A` reader - Timer/Counter3 Output Compare A Match Interrupt Enable"]
pub struct OCIE3A_R(crate::FieldReader<bool, bool>);
impl OCIE3A_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCIE3A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCIE3A_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCIE3A` writer - Timer/Counter3 Output Compare A Match Interrupt Enable"]
pub struct OCIE3A_W<'a> {
    w: &'a mut W,
}
impl<'a> OCIE3A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `OCIE3B` reader - Timer/Counter3 Output Compare B Match Interrupt Enable"]
pub struct OCIE3B_R(crate::FieldReader<bool, bool>);
impl OCIE3B_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCIE3B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCIE3B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCIE3B` writer - Timer/Counter3 Output Compare B Match Interrupt Enable"]
pub struct OCIE3B_W<'a> {
    w: &'a mut W,
}
impl<'a> OCIE3B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `OCIE3C` reader - Timer/Counter3 Output Compare C Match Interrupt Enable"]
pub struct OCIE3C_R(crate::FieldReader<bool, bool>);
impl OCIE3C_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCIE3C_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCIE3C_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCIE3C` writer - Timer/Counter3 Output Compare C Match Interrupt Enable"]
pub struct OCIE3C_W<'a> {
    w: &'a mut W,
}
impl<'a> OCIE3C_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `ICIE3` reader - Timer/Counter3 Input Capture Interrupt Enable"]
pub struct ICIE3_R(crate::FieldReader<bool, bool>);
impl ICIE3_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICIE3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICIE3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICIE3` writer - Timer/Counter3 Input Capture Interrupt Enable"]
pub struct ICIE3_W<'a> {
    w: &'a mut W,
}
impl<'a> ICIE3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Timer/Counter3 Overflow Interrupt Enable"]
    #[inline(always)]
    pub fn toie3(&self) -> TOIE3_R {
        TOIE3_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Timer/Counter3 Output Compare A Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie3a(&self) -> OCIE3A_R {
        OCIE3A_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Timer/Counter3 Output Compare B Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie3b(&self) -> OCIE3B_R {
        OCIE3B_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Timer/Counter3 Output Compare C Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie3c(&self) -> OCIE3C_R {
        OCIE3C_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Timer/Counter3 Input Capture Interrupt Enable"]
    #[inline(always)]
    pub fn icie3(&self) -> ICIE3_R {
        ICIE3_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Timer/Counter3 Overflow Interrupt Enable"]
    #[inline(always)]
    pub fn toie3(&mut self) -> TOIE3_W {
        TOIE3_W { w: self }
    }
    #[doc = "Bit 1 - Timer/Counter3 Output Compare A Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie3a(&mut self) -> OCIE3A_W {
        OCIE3A_W { w: self }
    }
    #[doc = "Bit 2 - Timer/Counter3 Output Compare B Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie3b(&mut self) -> OCIE3B_W {
        OCIE3B_W { w: self }
    }
    #[doc = "Bit 3 - Timer/Counter3 Output Compare C Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie3c(&mut self) -> OCIE3C_W {
        OCIE3C_W { w: self }
    }
    #[doc = "Bit 5 - Timer/Counter3 Input Capture Interrupt Enable"]
    #[inline(always)]
    pub fn icie3(&mut self) -> ICIE3_W {
        ICIE3_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter3 Interrupt Mask Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [timsk3](index.html) module"]
pub struct TIMSK3_SPEC;
impl crate::RegisterSpec for TIMSK3_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [timsk3::R](R) reader structure"]
impl crate::Readable for TIMSK3_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [timsk3::W](W) writer structure"]
impl crate::Writable for TIMSK3_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TIMSK3 to value 0"]
impl crate::Resettable for TIMSK3_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
