#[doc = "Register `DDRL` reader"]
pub struct R(crate::R<DDRL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DDRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DDRL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DDRL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DDRL` writer"]
pub struct W(crate::W<DDRL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DDRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DDRL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DDRL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PL0` reader - Pin L0"]
pub struct PL0_R(crate::FieldReader<bool, bool>);
impl PL0_R {
    pub(crate) fn new(bits: bool) -> Self {
        PL0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PL0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PL0` writer - Pin L0"]
pub struct PL0_W<'a> {
    w: &'a mut W,
}
impl<'a> PL0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `PL1` reader - Pin L1"]
pub struct PL1_R(crate::FieldReader<bool, bool>);
impl PL1_R {
    pub(crate) fn new(bits: bool) -> Self {
        PL1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PL1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PL1` writer - Pin L1"]
pub struct PL1_W<'a> {
    w: &'a mut W,
}
impl<'a> PL1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `PL2` reader - Pin L2"]
pub struct PL2_R(crate::FieldReader<bool, bool>);
impl PL2_R {
    pub(crate) fn new(bits: bool) -> Self {
        PL2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PL2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PL2` writer - Pin L2"]
pub struct PL2_W<'a> {
    w: &'a mut W,
}
impl<'a> PL2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `PL3` reader - Pin L3"]
pub struct PL3_R(crate::FieldReader<bool, bool>);
impl PL3_R {
    pub(crate) fn new(bits: bool) -> Self {
        PL3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PL3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PL3` writer - Pin L3"]
pub struct PL3_W<'a> {
    w: &'a mut W,
}
impl<'a> PL3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `PL4` reader - Pin L4"]
pub struct PL4_R(crate::FieldReader<bool, bool>);
impl PL4_R {
    pub(crate) fn new(bits: bool) -> Self {
        PL4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PL4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PL4` writer - Pin L4"]
pub struct PL4_W<'a> {
    w: &'a mut W,
}
impl<'a> PL4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `PL5` reader - Pin L5"]
pub struct PL5_R(crate::FieldReader<bool, bool>);
impl PL5_R {
    pub(crate) fn new(bits: bool) -> Self {
        PL5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PL5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PL5` writer - Pin L5"]
pub struct PL5_W<'a> {
    w: &'a mut W,
}
impl<'a> PL5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `PL6` reader - Pin L6"]
pub struct PL6_R(crate::FieldReader<bool, bool>);
impl PL6_R {
    pub(crate) fn new(bits: bool) -> Self {
        PL6_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PL6_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PL6` writer - Pin L6"]
pub struct PL6_W<'a> {
    w: &'a mut W,
}
impl<'a> PL6_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `PL7` reader - Pin L7"]
pub struct PL7_R(crate::FieldReader<bool, bool>);
impl PL7_R {
    pub(crate) fn new(bits: bool) -> Self {
        PL7_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PL7_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PL7` writer - Pin L7"]
pub struct PL7_W<'a> {
    w: &'a mut W,
}
impl<'a> PL7_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Pin L0"]
    #[inline(always)]
    pub fn pl0(&self) -> PL0_R {
        PL0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Pin L1"]
    #[inline(always)]
    pub fn pl1(&self) -> PL1_R {
        PL1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Pin L2"]
    #[inline(always)]
    pub fn pl2(&self) -> PL2_R {
        PL2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Pin L3"]
    #[inline(always)]
    pub fn pl3(&self) -> PL3_R {
        PL3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Pin L4"]
    #[inline(always)]
    pub fn pl4(&self) -> PL4_R {
        PL4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Pin L5"]
    #[inline(always)]
    pub fn pl5(&self) -> PL5_R {
        PL5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Pin L6"]
    #[inline(always)]
    pub fn pl6(&self) -> PL6_R {
        PL6_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Pin L7"]
    #[inline(always)]
    pub fn pl7(&self) -> PL7_R {
        PL7_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Pin L0"]
    #[inline(always)]
    pub fn pl0(&mut self) -> PL0_W {
        PL0_W { w: self }
    }
    #[doc = "Bit 1 - Pin L1"]
    #[inline(always)]
    pub fn pl1(&mut self) -> PL1_W {
        PL1_W { w: self }
    }
    #[doc = "Bit 2 - Pin L2"]
    #[inline(always)]
    pub fn pl2(&mut self) -> PL2_W {
        PL2_W { w: self }
    }
    #[doc = "Bit 3 - Pin L3"]
    #[inline(always)]
    pub fn pl3(&mut self) -> PL3_W {
        PL3_W { w: self }
    }
    #[doc = "Bit 4 - Pin L4"]
    #[inline(always)]
    pub fn pl4(&mut self) -> PL4_W {
        PL4_W { w: self }
    }
    #[doc = "Bit 5 - Pin L5"]
    #[inline(always)]
    pub fn pl5(&mut self) -> PL5_W {
        PL5_W { w: self }
    }
    #[doc = "Bit 6 - Pin L6"]
    #[inline(always)]
    pub fn pl6(&mut self) -> PL6_W {
        PL6_W { w: self }
    }
    #[doc = "Bit 7 - Pin L7"]
    #[inline(always)]
    pub fn pl7(&mut self) -> PL7_W {
        PL7_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "PORT L Data Direction Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ddrl](index.html) module"]
pub struct DDRL_SPEC;
impl crate::RegisterSpec for DDRL_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ddrl::R](R) reader structure"]
impl crate::Readable for DDRL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ddrl::W](W) writer structure"]
impl crate::Writable for DDRL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DDRL to value 0"]
impl crate::Resettable for DDRL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
