#[doc = "Register `XMCRA` reader"]
pub struct R(crate::R<XMCRA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<XMCRA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<XMCRA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<XMCRA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `XMCRA` writer"]
pub struct W(crate::W<XMCRA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<XMCRA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<XMCRA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<XMCRA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Wait state select bit lower page\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum SRW0_A {
    #[doc = "0: No wait-states"]
    VAL_0X00 = 0,
    #[doc = "1: Wait one cycle during read/write strobe"]
    VAL_0X01 = 1,
    #[doc = "2: Wait two cycles during read/write strobe"]
    VAL_0X02 = 2,
    #[doc = "3: Wait two cycles during read/write and wait one cycle before driving out new address"]
    VAL_0X03 = 3,
}
impl From<SRW0_A> for u8 {
    #[inline(always)]
    fn from(variant: SRW0_A) -> Self {
        variant as _
    }
}
#[doc = "Field `SRW0` reader - Wait state select bit lower page"]
pub struct SRW0_R(crate::FieldReader<u8, SRW0_A>);
impl SRW0_R {
    pub(crate) fn new(bits: u8) -> Self {
        SRW0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> SRW0_A {
        match self.bits {
            0 => SRW0_A::VAL_0X00,
            1 => SRW0_A::VAL_0X01,
            2 => SRW0_A::VAL_0X02,
            3 => SRW0_A::VAL_0X03,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `VAL_0X00`"]
    #[inline(always)]
    pub fn is_val_0x00(&self) -> bool {
        **self == SRW0_A::VAL_0X00
    }
    #[doc = "Checks if the value of the field is `VAL_0X01`"]
    #[inline(always)]
    pub fn is_val_0x01(&self) -> bool {
        **self == SRW0_A::VAL_0X01
    }
    #[doc = "Checks if the value of the field is `VAL_0X02`"]
    #[inline(always)]
    pub fn is_val_0x02(&self) -> bool {
        **self == SRW0_A::VAL_0X02
    }
    #[doc = "Checks if the value of the field is `VAL_0X03`"]
    #[inline(always)]
    pub fn is_val_0x03(&self) -> bool {
        **self == SRW0_A::VAL_0X03
    }
}
impl core::ops::Deref for SRW0_R {
    type Target = crate::FieldReader<u8, SRW0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SRW0` writer - Wait state select bit lower page"]
pub struct SRW0_W<'a> {
    w: &'a mut W,
}
impl<'a> SRW0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: SRW0_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "No wait-states"]
    #[inline(always)]
    pub fn val_0x00(self) -> &'a mut W {
        self.variant(SRW0_A::VAL_0X00)
    }
    #[doc = "Wait one cycle during read/write strobe"]
    #[inline(always)]
    pub fn val_0x01(self) -> &'a mut W {
        self.variant(SRW0_A::VAL_0X01)
    }
    #[doc = "Wait two cycles during read/write strobe"]
    #[inline(always)]
    pub fn val_0x02(self) -> &'a mut W {
        self.variant(SRW0_A::VAL_0X02)
    }
    #[doc = "Wait two cycles during read/write and wait one cycle before driving out new address"]
    #[inline(always)]
    pub fn val_0x03(self) -> &'a mut W {
        self.variant(SRW0_A::VAL_0X03)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Wait state select bit upper page\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum SRW1_A {
    #[doc = "0: No wait-states"]
    VAL_0X00 = 0,
    #[doc = "1: Wait one cycle during read/write strobe"]
    VAL_0X01 = 1,
    #[doc = "2: Wait two cycles during read/write strobe"]
    VAL_0X02 = 2,
    #[doc = "3: Wait two cycles during read/write and wait one cycle before driving out new address"]
    VAL_0X03 = 3,
}
impl From<SRW1_A> for u8 {
    #[inline(always)]
    fn from(variant: SRW1_A) -> Self {
        variant as _
    }
}
#[doc = "Field `SRW1` reader - Wait state select bit upper page"]
pub struct SRW1_R(crate::FieldReader<u8, SRW1_A>);
impl SRW1_R {
    pub(crate) fn new(bits: u8) -> Self {
        SRW1_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> SRW1_A {
        match self.bits {
            0 => SRW1_A::VAL_0X00,
            1 => SRW1_A::VAL_0X01,
            2 => SRW1_A::VAL_0X02,
            3 => SRW1_A::VAL_0X03,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `VAL_0X00`"]
    #[inline(always)]
    pub fn is_val_0x00(&self) -> bool {
        **self == SRW1_A::VAL_0X00
    }
    #[doc = "Checks if the value of the field is `VAL_0X01`"]
    #[inline(always)]
    pub fn is_val_0x01(&self) -> bool {
        **self == SRW1_A::VAL_0X01
    }
    #[doc = "Checks if the value of the field is `VAL_0X02`"]
    #[inline(always)]
    pub fn is_val_0x02(&self) -> bool {
        **self == SRW1_A::VAL_0X02
    }
    #[doc = "Checks if the value of the field is `VAL_0X03`"]
    #[inline(always)]
    pub fn is_val_0x03(&self) -> bool {
        **self == SRW1_A::VAL_0X03
    }
}
impl core::ops::Deref for SRW1_R {
    type Target = crate::FieldReader<u8, SRW1_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SRW1` writer - Wait state select bit upper page"]
pub struct SRW1_W<'a> {
    w: &'a mut W,
}
impl<'a> SRW1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: SRW1_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "No wait-states"]
    #[inline(always)]
    pub fn val_0x00(self) -> &'a mut W {
        self.variant(SRW1_A::VAL_0X00)
    }
    #[doc = "Wait one cycle during read/write strobe"]
    #[inline(always)]
    pub fn val_0x01(self) -> &'a mut W {
        self.variant(SRW1_A::VAL_0X01)
    }
    #[doc = "Wait two cycles during read/write strobe"]
    #[inline(always)]
    pub fn val_0x02(self) -> &'a mut W {
        self.variant(SRW1_A::VAL_0X02)
    }
    #[doc = "Wait two cycles during read/write and wait one cycle before driving out new address"]
    #[inline(always)]
    pub fn val_0x03(self) -> &'a mut W {
        self.variant(SRW1_A::VAL_0X03)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u8 & 0x03) << 2);
        self.w
    }
}
#[doc = "Wait state page limit\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum SRL_A {
    #[doc = "0: LS = N/A, US = 0x1100 - 0xFFFF"]
    VAL_0X00 = 0,
    #[doc = "1: LS = 0x2200 - 0x1FFF, US = 0x2000 - 0xFFFF"]
    VAL_0X01 = 1,
    #[doc = "2: LS = 0x2200 - 0x3FFF, US = 0x4000 - 0xFFFF"]
    VAL_0X02 = 2,
    #[doc = "3: LS = 0x2200 - 0x5FFF, US = 0x6000 - 0xFFFF"]
    VAL_0X03 = 3,
    #[doc = "4: LS = 0x2200 - 0x7FFF, US = 0x8000 - 0xFFFF"]
    VAL_0X04 = 4,
    #[doc = "5: LS = 0x2200 - 0x9FFF, US = 0xA000 - 0xFFFF"]
    VAL_0X05 = 5,
    #[doc = "6: LS = 0x2200 - 0xBFFF, US = 0xC000 - 0xFFFF"]
    VAL_0X06 = 6,
    #[doc = "7: LS = 0x2200 - 0xDFFF, US = 0xE000 - 0xFFFF"]
    VAL_0X07 = 7,
}
impl From<SRL_A> for u8 {
    #[inline(always)]
    fn from(variant: SRL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `SRL` reader - Wait state page limit"]
pub struct SRL_R(crate::FieldReader<u8, SRL_A>);
impl SRL_R {
    pub(crate) fn new(bits: u8) -> Self {
        SRL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> SRL_A {
        match self.bits {
            0 => SRL_A::VAL_0X00,
            1 => SRL_A::VAL_0X01,
            2 => SRL_A::VAL_0X02,
            3 => SRL_A::VAL_0X03,
            4 => SRL_A::VAL_0X04,
            5 => SRL_A::VAL_0X05,
            6 => SRL_A::VAL_0X06,
            7 => SRL_A::VAL_0X07,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `VAL_0X00`"]
    #[inline(always)]
    pub fn is_val_0x00(&self) -> bool {
        **self == SRL_A::VAL_0X00
    }
    #[doc = "Checks if the value of the field is `VAL_0X01`"]
    #[inline(always)]
    pub fn is_val_0x01(&self) -> bool {
        **self == SRL_A::VAL_0X01
    }
    #[doc = "Checks if the value of the field is `VAL_0X02`"]
    #[inline(always)]
    pub fn is_val_0x02(&self) -> bool {
        **self == SRL_A::VAL_0X02
    }
    #[doc = "Checks if the value of the field is `VAL_0X03`"]
    #[inline(always)]
    pub fn is_val_0x03(&self) -> bool {
        **self == SRL_A::VAL_0X03
    }
    #[doc = "Checks if the value of the field is `VAL_0X04`"]
    #[inline(always)]
    pub fn is_val_0x04(&self) -> bool {
        **self == SRL_A::VAL_0X04
    }
    #[doc = "Checks if the value of the field is `VAL_0X05`"]
    #[inline(always)]
    pub fn is_val_0x05(&self) -> bool {
        **self == SRL_A::VAL_0X05
    }
    #[doc = "Checks if the value of the field is `VAL_0X06`"]
    #[inline(always)]
    pub fn is_val_0x06(&self) -> bool {
        **self == SRL_A::VAL_0X06
    }
    #[doc = "Checks if the value of the field is `VAL_0X07`"]
    #[inline(always)]
    pub fn is_val_0x07(&self) -> bool {
        **self == SRL_A::VAL_0X07
    }
}
impl core::ops::Deref for SRL_R {
    type Target = crate::FieldReader<u8, SRL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SRL` writer - Wait state page limit"]
pub struct SRL_W<'a> {
    w: &'a mut W,
}
impl<'a> SRL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: SRL_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "LS = N/A, US = 0x1100 - 0xFFFF"]
    #[inline(always)]
    pub fn val_0x00(self) -> &'a mut W {
        self.variant(SRL_A::VAL_0X00)
    }
    #[doc = "LS = 0x2200 - 0x1FFF, US = 0x2000 - 0xFFFF"]
    #[inline(always)]
    pub fn val_0x01(self) -> &'a mut W {
        self.variant(SRL_A::VAL_0X01)
    }
    #[doc = "LS = 0x2200 - 0x3FFF, US = 0x4000 - 0xFFFF"]
    #[inline(always)]
    pub fn val_0x02(self) -> &'a mut W {
        self.variant(SRL_A::VAL_0X02)
    }
    #[doc = "LS = 0x2200 - 0x5FFF, US = 0x6000 - 0xFFFF"]
    #[inline(always)]
    pub fn val_0x03(self) -> &'a mut W {
        self.variant(SRL_A::VAL_0X03)
    }
    #[doc = "LS = 0x2200 - 0x7FFF, US = 0x8000 - 0xFFFF"]
    #[inline(always)]
    pub fn val_0x04(self) -> &'a mut W {
        self.variant(SRL_A::VAL_0X04)
    }
    #[doc = "LS = 0x2200 - 0x9FFF, US = 0xA000 - 0xFFFF"]
    #[inline(always)]
    pub fn val_0x05(self) -> &'a mut W {
        self.variant(SRL_A::VAL_0X05)
    }
    #[doc = "LS = 0x2200 - 0xBFFF, US = 0xC000 - 0xFFFF"]
    #[inline(always)]
    pub fn val_0x06(self) -> &'a mut W {
        self.variant(SRL_A::VAL_0X06)
    }
    #[doc = "LS = 0x2200 - 0xDFFF, US = 0xE000 - 0xFFFF"]
    #[inline(always)]
    pub fn val_0x07(self) -> &'a mut W {
        self.variant(SRL_A::VAL_0X07)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 4)) | ((value as u8 & 0x07) << 4);
        self.w
    }
}
#[doc = "Field `SRE` reader - External SRAM Enable"]
pub struct SRE_R(crate::FieldReader<bool, bool>);
impl SRE_R {
    pub(crate) fn new(bits: bool) -> Self {
        SRE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SRE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SRE` writer - External SRAM Enable"]
pub struct SRE_W<'a> {
    w: &'a mut W,
}
impl<'a> SRE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Wait state select bit lower page"]
    #[inline(always)]
    pub fn srw0(&self) -> SRW0_R {
        SRW0_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - Wait state select bit upper page"]
    #[inline(always)]
    pub fn srw1(&self) -> SRW1_R {
        SRW1_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 4:6 - Wait state page limit"]
    #[inline(always)]
    pub fn srl(&self) -> SRL_R {
        SRL_R::new(((self.bits >> 4) & 0x07) as u8)
    }
    #[doc = "Bit 7 - External SRAM Enable"]
    #[inline(always)]
    pub fn sre(&self) -> SRE_R {
        SRE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - Wait state select bit lower page"]
    #[inline(always)]
    pub fn srw0(&mut self) -> SRW0_W {
        SRW0_W { w: self }
    }
    #[doc = "Bits 2:3 - Wait state select bit upper page"]
    #[inline(always)]
    pub fn srw1(&mut self) -> SRW1_W {
        SRW1_W { w: self }
    }
    #[doc = "Bits 4:6 - Wait state page limit"]
    #[inline(always)]
    pub fn srl(&mut self) -> SRL_W {
        SRL_W { w: self }
    }
    #[doc = "Bit 7 - External SRAM Enable"]
    #[inline(always)]
    pub fn sre(&mut self) -> SRE_W {
        SRE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "External Memory Control Register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [xmcra](index.html) module"]
pub struct XMCRA_SPEC;
impl crate::RegisterSpec for XMCRA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [xmcra::R](R) reader structure"]
impl crate::Readable for XMCRA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [xmcra::W](W) writer structure"]
impl crate::Writable for XMCRA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets XMCRA to value 0"]
impl crate::Resettable for XMCRA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
