#[doc = "Register `WDTCSR` reader"]
pub struct R(crate::R<WDTCSR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<WDTCSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<WDTCSR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<WDTCSR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `WDTCSR` writer"]
pub struct W(crate::W<WDTCSR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<WDTCSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<WDTCSR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<WDTCSR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Watchdog Timer Prescaler Bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum WDP_A {
    #[doc = "0: Oscillator Cycles 2K"]
    VAL_0X00 = 0,
    #[doc = "1: Oscillator Cycles 4K"]
    VAL_0X01 = 1,
    #[doc = "2: Oscillator Cycles 8K"]
    VAL_0X02 = 2,
    #[doc = "3: Oscillator Cycles 16K"]
    VAL_0X03 = 3,
    #[doc = "4: Oscillator Cycles 32K"]
    VAL_0X04 = 4,
    #[doc = "5: Oscillator Cycles 64K"]
    VAL_0X05 = 5,
    #[doc = "6: Oscillator Cycles 128K"]
    VAL_0X06 = 6,
    #[doc = "7: Oscillator Cycles 256K"]
    VAL_0X07 = 7,
}
impl From<WDP_A> for u8 {
    #[inline(always)]
    fn from(variant: WDP_A) -> Self {
        variant as _
    }
}
#[doc = "Field `WDP` reader - Watchdog Timer Prescaler Bits"]
pub struct WDP_R(crate::FieldReader<u8, WDP_A>);
impl WDP_R {
    pub(crate) fn new(bits: u8) -> Self {
        WDP_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<WDP_A> {
        match self.bits {
            0 => Some(WDP_A::VAL_0X00),
            1 => Some(WDP_A::VAL_0X01),
            2 => Some(WDP_A::VAL_0X02),
            3 => Some(WDP_A::VAL_0X03),
            4 => Some(WDP_A::VAL_0X04),
            5 => Some(WDP_A::VAL_0X05),
            6 => Some(WDP_A::VAL_0X06),
            7 => Some(WDP_A::VAL_0X07),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `VAL_0X00`"]
    #[inline(always)]
    pub fn is_val_0x00(&self) -> bool {
        **self == WDP_A::VAL_0X00
    }
    #[doc = "Checks if the value of the field is `VAL_0X01`"]
    #[inline(always)]
    pub fn is_val_0x01(&self) -> bool {
        **self == WDP_A::VAL_0X01
    }
    #[doc = "Checks if the value of the field is `VAL_0X02`"]
    #[inline(always)]
    pub fn is_val_0x02(&self) -> bool {
        **self == WDP_A::VAL_0X02
    }
    #[doc = "Checks if the value of the field is `VAL_0X03`"]
    #[inline(always)]
    pub fn is_val_0x03(&self) -> bool {
        **self == WDP_A::VAL_0X03
    }
    #[doc = "Checks if the value of the field is `VAL_0X04`"]
    #[inline(always)]
    pub fn is_val_0x04(&self) -> bool {
        **self == WDP_A::VAL_0X04
    }
    #[doc = "Checks if the value of the field is `VAL_0X05`"]
    #[inline(always)]
    pub fn is_val_0x05(&self) -> bool {
        **self == WDP_A::VAL_0X05
    }
    #[doc = "Checks if the value of the field is `VAL_0X06`"]
    #[inline(always)]
    pub fn is_val_0x06(&self) -> bool {
        **self == WDP_A::VAL_0X06
    }
    #[doc = "Checks if the value of the field is `VAL_0X07`"]
    #[inline(always)]
    pub fn is_val_0x07(&self) -> bool {
        **self == WDP_A::VAL_0X07
    }
}
impl core::ops::Deref for WDP_R {
    type Target = crate::FieldReader<u8, WDP_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WDP` writer - Watchdog Timer Prescaler Bits"]
pub struct WDP_W<'a> {
    w: &'a mut W,
}
impl<'a> WDP_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: WDP_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Oscillator Cycles 2K"]
    #[inline(always)]
    pub fn val_0x00(self) -> &'a mut W {
        self.variant(WDP_A::VAL_0X00)
    }
    #[doc = "Oscillator Cycles 4K"]
    #[inline(always)]
    pub fn val_0x01(self) -> &'a mut W {
        self.variant(WDP_A::VAL_0X01)
    }
    #[doc = "Oscillator Cycles 8K"]
    #[inline(always)]
    pub fn val_0x02(self) -> &'a mut W {
        self.variant(WDP_A::VAL_0X02)
    }
    #[doc = "Oscillator Cycles 16K"]
    #[inline(always)]
    pub fn val_0x03(self) -> &'a mut W {
        self.variant(WDP_A::VAL_0X03)
    }
    #[doc = "Oscillator Cycles 32K"]
    #[inline(always)]
    pub fn val_0x04(self) -> &'a mut W {
        self.variant(WDP_A::VAL_0X04)
    }
    #[doc = "Oscillator Cycles 64K"]
    #[inline(always)]
    pub fn val_0x05(self) -> &'a mut W {
        self.variant(WDP_A::VAL_0X05)
    }
    #[doc = "Oscillator Cycles 128K"]
    #[inline(always)]
    pub fn val_0x06(self) -> &'a mut W {
        self.variant(WDP_A::VAL_0X06)
    }
    #[doc = "Oscillator Cycles 256K"]
    #[inline(always)]
    pub fn val_0x07(self) -> &'a mut W {
        self.variant(WDP_A::VAL_0X07)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x3f) | (value as u8 & 0x3f);
        self.w
    }
}
#[doc = "Field `WDE` reader - Watch Dog Enable"]
pub struct WDE_R(crate::FieldReader<bool, bool>);
impl WDE_R {
    pub(crate) fn new(bits: bool) -> Self {
        WDE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WDE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WDE` writer - Watch Dog Enable"]
pub struct WDE_W<'a> {
    w: &'a mut W,
}
impl<'a> WDE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `WDCE` reader - Watchdog Change Enable"]
pub struct WDCE_R(crate::FieldReader<bool, bool>);
impl WDCE_R {
    pub(crate) fn new(bits: bool) -> Self {
        WDCE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WDCE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WDCE` writer - Watchdog Change Enable"]
pub struct WDCE_W<'a> {
    w: &'a mut W,
}
impl<'a> WDCE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `WDIE` reader - Watchdog Timeout Interrupt Enable"]
pub struct WDIE_R(crate::FieldReader<bool, bool>);
impl WDIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        WDIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WDIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WDIE` writer - Watchdog Timeout Interrupt Enable"]
pub struct WDIE_W<'a> {
    w: &'a mut W,
}
impl<'a> WDIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `WDIF` reader - Watchdog Timeout Interrupt Flag"]
pub struct WDIF_R(crate::FieldReader<bool, bool>);
impl WDIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        WDIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WDIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WDIF` writer - Watchdog Timeout Interrupt Flag"]
pub struct WDIF_W<'a> {
    w: &'a mut W,
}
impl<'a> WDIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:5 - Watchdog Timer Prescaler Bits"]
    #[inline(always)]
    pub fn wdp(&self) -> WDP_R {
        WDP_R::new((self.bits & 0x3f) as u8)
    }
    #[doc = "Bit 3 - Watch Dog Enable"]
    #[inline(always)]
    pub fn wde(&self) -> WDE_R {
        WDE_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Watchdog Change Enable"]
    #[inline(always)]
    pub fn wdce(&self) -> WDCE_R {
        WDCE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Watchdog Timeout Interrupt Enable"]
    #[inline(always)]
    pub fn wdie(&self) -> WDIE_R {
        WDIE_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Watchdog Timeout Interrupt Flag"]
    #[inline(always)]
    pub fn wdif(&self) -> WDIF_R {
        WDIF_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:5 - Watchdog Timer Prescaler Bits"]
    #[inline(always)]
    pub fn wdp(&mut self) -> WDP_W {
        WDP_W { w: self }
    }
    #[doc = "Bit 3 - Watch Dog Enable"]
    #[inline(always)]
    pub fn wde(&mut self) -> WDE_W {
        WDE_W { w: self }
    }
    #[doc = "Bit 4 - Watchdog Change Enable"]
    #[inline(always)]
    pub fn wdce(&mut self) -> WDCE_W {
        WDCE_W { w: self }
    }
    #[doc = "Bit 6 - Watchdog Timeout Interrupt Enable"]
    #[inline(always)]
    pub fn wdie(&mut self) -> WDIE_W {
        WDIE_W { w: self }
    }
    #[doc = "Bit 7 - Watchdog Timeout Interrupt Flag"]
    #[inline(always)]
    pub fn wdif(&mut self) -> WDIF_W {
        WDIF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Watchdog Timer Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [wdtcsr](index.html) module"]
pub struct WDTCSR_SPEC;
impl crate::RegisterSpec for WDTCSR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [wdtcsr::R](R) reader structure"]
impl crate::Readable for WDTCSR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [wdtcsr::W](W) writer structure"]
impl crate::Writable for WDTCSR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets WDTCSR to value 0"]
impl crate::Resettable for WDTCSR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
