#[doc = "Register `USBCON` reader"]
pub struct R(crate::R<USBCON_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<USBCON_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<USBCON_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<USBCON_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `USBCON` writer"]
pub struct W(crate::W<USBCON_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<USBCON_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<USBCON_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<USBCON_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `VBUSTE` reader - No Description."]
pub struct VBUSTE_R(crate::FieldReader<bool, bool>);
impl VBUSTE_R {
    pub(crate) fn new(bits: bool) -> Self {
        VBUSTE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for VBUSTE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `VBUSTE` writer - No Description."]
pub struct VBUSTE_W<'a> {
    w: &'a mut W,
}
impl<'a> VBUSTE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `IDTE` reader - No Description."]
pub struct IDTE_R(crate::FieldReader<bool, bool>);
impl IDTE_R {
    pub(crate) fn new(bits: bool) -> Self {
        IDTE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IDTE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IDTE` writer - No Description."]
pub struct IDTE_W<'a> {
    w: &'a mut W,
}
impl<'a> IDTE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `OTGPADE` reader - No Description."]
pub struct OTGPADE_R(crate::FieldReader<bool, bool>);
impl OTGPADE_R {
    pub(crate) fn new(bits: bool) -> Self {
        OTGPADE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OTGPADE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OTGPADE` writer - No Description."]
pub struct OTGPADE_W<'a> {
    w: &'a mut W,
}
impl<'a> OTGPADE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `FRZCLK` reader - No Description."]
pub struct FRZCLK_R(crate::FieldReader<bool, bool>);
impl FRZCLK_R {
    pub(crate) fn new(bits: bool) -> Self {
        FRZCLK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FRZCLK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FRZCLK` writer - No Description."]
pub struct FRZCLK_W<'a> {
    w: &'a mut W,
}
impl<'a> FRZCLK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `HOST` reader - No Description."]
pub struct HOST_R(crate::FieldReader<bool, bool>);
impl HOST_R {
    pub(crate) fn new(bits: bool) -> Self {
        HOST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HOST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HOST` writer - No Description."]
pub struct HOST_W<'a> {
    w: &'a mut W,
}
impl<'a> HOST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `USBE` reader - No Description."]
pub struct USBE_R(crate::FieldReader<bool, bool>);
impl USBE_R {
    pub(crate) fn new(bits: bool) -> Self {
        USBE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for USBE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USBE` writer - No Description."]
pub struct USBE_W<'a> {
    w: &'a mut W,
}
impl<'a> USBE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn vbuste(&self) -> VBUSTE_R {
        VBUSTE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - No Description."]
    #[inline(always)]
    pub fn idte(&self) -> IDTE_R {
        IDTE_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 4 - No Description."]
    #[inline(always)]
    pub fn otgpade(&self) -> OTGPADE_R {
        OTGPADE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - No Description."]
    #[inline(always)]
    pub fn frzclk(&self) -> FRZCLK_R {
        FRZCLK_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - No Description."]
    #[inline(always)]
    pub fn host(&self) -> HOST_R {
        HOST_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - No Description."]
    #[inline(always)]
    pub fn usbe(&self) -> USBE_R {
        USBE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn vbuste(&mut self) -> VBUSTE_W {
        VBUSTE_W { w: self }
    }
    #[doc = "Bit 1 - No Description."]
    #[inline(always)]
    pub fn idte(&mut self) -> IDTE_W {
        IDTE_W { w: self }
    }
    #[doc = "Bit 4 - No Description."]
    #[inline(always)]
    pub fn otgpade(&mut self) -> OTGPADE_W {
        OTGPADE_W { w: self }
    }
    #[doc = "Bit 5 - No Description."]
    #[inline(always)]
    pub fn frzclk(&mut self) -> FRZCLK_W {
        FRZCLK_W { w: self }
    }
    #[doc = "Bit 6 - No Description."]
    #[inline(always)]
    pub fn host(&mut self) -> HOST_W {
        HOST_W { w: self }
    }
    #[doc = "Bit 7 - No Description."]
    #[inline(always)]
    pub fn usbe(&mut self) -> USBE_W {
        USBE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USB General Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [usbcon](index.html) module"]
pub struct USBCON_SPEC;
impl crate::RegisterSpec for USBCON_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [usbcon::R](R) reader structure"]
impl crate::Readable for USBCON_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [usbcon::W](W) writer structure"]
impl crate::Writable for USBCON_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets USBCON to value 0"]
impl crate::Resettable for USBCON_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
