#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - TWI Bit Rate register"]
    pub twbr: crate::Reg<twbr::TWBR_SPEC>,
    #[doc = "0x01 - TWI Status Register"]
    pub twsr: crate::Reg<twsr::TWSR_SPEC>,
    #[doc = "0x02 - TWI (Slave) Address register"]
    pub twar: crate::Reg<twar::TWAR_SPEC>,
    #[doc = "0x03 - TWI Data register"]
    pub twdr: crate::Reg<twdr::TWDR_SPEC>,
    #[doc = "0x04 - TWI Control Register"]
    pub twcr: crate::Reg<twcr::TWCR_SPEC>,
    #[doc = "0x05 - TWI (Slave) Address Mask Register"]
    pub twamr: crate::Reg<twamr::TWAMR_SPEC>,
    #[doc = "0x06 - TWHSR"]
    pub twhsr: crate::Reg<twhsr::TWHSR_SPEC>,
}
#[doc = "TWAMR register accessor: an alias for `Reg<TWAMR_SPEC>`"]
pub type TWAMR = crate::Reg<twamr::TWAMR_SPEC>;
#[doc = "TWI (Slave) Address Mask Register"]
pub mod twamr;
#[doc = "TWAR register accessor: an alias for `Reg<TWAR_SPEC>`"]
pub type TWAR = crate::Reg<twar::TWAR_SPEC>;
#[doc = "TWI (Slave) Address register"]
pub mod twar;
#[doc = "TWBR register accessor: an alias for `Reg<TWBR_SPEC>`"]
pub type TWBR = crate::Reg<twbr::TWBR_SPEC>;
#[doc = "TWI Bit Rate register"]
pub mod twbr;
#[doc = "TWCR register accessor: an alias for `Reg<TWCR_SPEC>`"]
pub type TWCR = crate::Reg<twcr::TWCR_SPEC>;
#[doc = "TWI Control Register"]
pub mod twcr;
#[doc = "TWDR register accessor: an alias for `Reg<TWDR_SPEC>`"]
pub type TWDR = crate::Reg<twdr::TWDR_SPEC>;
#[doc = "TWI Data register"]
pub mod twdr;
#[doc = "TWHSR register accessor: an alias for `Reg<TWHSR_SPEC>`"]
pub type TWHSR = crate::Reg<twhsr::TWHSR_SPEC>;
#[doc = "TWHSR"]
pub mod twhsr;
#[doc = "TWSR register accessor: an alias for `Reg<TWSR_SPEC>`"]
pub type TWSR = crate::Reg<twsr::TWSR_SPEC>;
#[doc = "TWI Status Register"]
pub mod twsr;
