#[doc = "Register `TCCR0A` reader"]
pub struct R(crate::R<TCCR0A_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR0A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR0A_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR0A_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR0A` writer"]
pub struct W(crate::W<TCCR0A_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR0A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR0A_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR0A_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `WGM00` reader - Waveform Generation Mode"]
pub struct WGM00_R(crate::FieldReader<bool, bool>);
impl WGM00_R {
    pub(crate) fn new(bits: bool) -> Self {
        WGM00_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WGM00_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM00` writer - Waveform Generation Mode"]
pub struct WGM00_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM00_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `ACIC0` reader - Analog Comparator Input Capture Enable"]
pub struct ACIC0_R(crate::FieldReader<bool, bool>);
impl ACIC0_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACIC0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACIC0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACIC0` writer - Analog Comparator Input Capture Enable"]
pub struct ACIC0_W<'a> {
    w: &'a mut W,
}
impl<'a> ACIC0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `ICES0` reader - Input Capture Edge Select"]
pub struct ICES0_R(crate::FieldReader<bool, bool>);
impl ICES0_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICES0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICES0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICES0` writer - Input Capture Edge Select"]
pub struct ICES0_W<'a> {
    w: &'a mut W,
}
impl<'a> ICES0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `ICNC0` reader - Input Capture Noice Canceler"]
pub struct ICNC0_R(crate::FieldReader<bool, bool>);
impl ICNC0_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICNC0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICNC0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICNC0` writer - Input Capture Noice Canceler"]
pub struct ICNC0_W<'a> {
    w: &'a mut W,
}
impl<'a> ICNC0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `ICEN0` reader - Input Capture Mode Enable"]
pub struct ICEN0_R(crate::FieldReader<bool, bool>);
impl ICEN0_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICEN0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICEN0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICEN0` writer - Input Capture Mode Enable"]
pub struct ICEN0_W<'a> {
    w: &'a mut W,
}
impl<'a> ICEN0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `TCW0` reader - Timer/Counter 0 Width"]
pub struct TCW0_R(crate::FieldReader<bool, bool>);
impl TCW0_R {
    pub(crate) fn new(bits: bool) -> Self {
        TCW0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TCW0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TCW0` writer - Timer/Counter 0 Width"]
pub struct TCW0_W<'a> {
    w: &'a mut W,
}
impl<'a> TCW0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm00(&self) -> WGM00_R {
        WGM00_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 3 - Analog Comparator Input Capture Enable"]
    #[inline(always)]
    pub fn acic0(&self) -> ACIC0_R {
        ACIC0_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Input Capture Edge Select"]
    #[inline(always)]
    pub fn ices0(&self) -> ICES0_R {
        ICES0_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Input Capture Noice Canceler"]
    #[inline(always)]
    pub fn icnc0(&self) -> ICNC0_R {
        ICNC0_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Input Capture Mode Enable"]
    #[inline(always)]
    pub fn icen0(&self) -> ICEN0_R {
        ICEN0_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Timer/Counter 0 Width"]
    #[inline(always)]
    pub fn tcw0(&self) -> TCW0_R {
        TCW0_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm00(&mut self) -> WGM00_W {
        WGM00_W { w: self }
    }
    #[doc = "Bit 3 - Analog Comparator Input Capture Enable"]
    #[inline(always)]
    pub fn acic0(&mut self) -> ACIC0_W {
        ACIC0_W { w: self }
    }
    #[doc = "Bit 4 - Input Capture Edge Select"]
    #[inline(always)]
    pub fn ices0(&mut self) -> ICES0_W {
        ICES0_W { w: self }
    }
    #[doc = "Bit 5 - Input Capture Noice Canceler"]
    #[inline(always)]
    pub fn icnc0(&mut self) -> ICNC0_W {
        ICNC0_W { w: self }
    }
    #[doc = "Bit 6 - Input Capture Mode Enable"]
    #[inline(always)]
    pub fn icen0(&mut self) -> ICEN0_W {
        ICEN0_W { w: self }
    }
    #[doc = "Bit 7 - Timer/Counter 0 Width"]
    #[inline(always)]
    pub fn tcw0(&mut self) -> TCW0_W {
        TCW0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter Control Register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr0a](index.html) module"]
pub struct TCCR0A_SPEC;
impl crate::RegisterSpec for TCCR0A_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr0a::R](R) reader structure"]
impl crate::Readable for TCCR0A_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr0a::W](W) writer structure"]
impl crate::Writable for TCCR0A_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR0A to value 0"]
impl crate::Resettable for TCCR0A_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
