#[doc = "Register `ACSRA` reader"]
pub struct R(crate::R<ACSRA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ACSRA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ACSRA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ACSRA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ACSRA` writer"]
pub struct W(crate::W<ACSRA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ACSRA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ACSRA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ACSRA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Analog Comparator Interrupt Mode Select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum ACIS_A {
    #[doc = "0: Interrupt on Toggle"]
    ON_TOGGLE = 0,
    #[doc = "2: Interrupt on Falling Edge"]
    ON_FALLING_EDGE = 2,
    #[doc = "3: Interrupt on Rising Edge"]
    ON_RISING_EDGE = 3,
}
impl From<ACIS_A> for u8 {
    #[inline(always)]
    fn from(variant: ACIS_A) -> Self {
        variant as _
    }
}
#[doc = "Field `ACIS` reader - Analog Comparator Interrupt Mode Select"]
pub struct ACIS_R(crate::FieldReader<u8, ACIS_A>);
impl ACIS_R {
    pub(crate) fn new(bits: u8) -> Self {
        ACIS_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<ACIS_A> {
        match self.bits {
            0 => Some(ACIS_A::ON_TOGGLE),
            2 => Some(ACIS_A::ON_FALLING_EDGE),
            3 => Some(ACIS_A::ON_RISING_EDGE),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `ON_TOGGLE`"]
    #[inline(always)]
    pub fn is_on_toggle(&self) -> bool {
        **self == ACIS_A::ON_TOGGLE
    }
    #[doc = "Checks if the value of the field is `ON_FALLING_EDGE`"]
    #[inline(always)]
    pub fn is_on_falling_edge(&self) -> bool {
        **self == ACIS_A::ON_FALLING_EDGE
    }
    #[doc = "Checks if the value of the field is `ON_RISING_EDGE`"]
    #[inline(always)]
    pub fn is_on_rising_edge(&self) -> bool {
        **self == ACIS_A::ON_RISING_EDGE
    }
}
impl core::ops::Deref for ACIS_R {
    type Target = crate::FieldReader<u8, ACIS_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACIS` writer - Analog Comparator Interrupt Mode Select"]
pub struct ACIS_W<'a> {
    w: &'a mut W,
}
impl<'a> ACIS_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: ACIS_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Interrupt on Toggle"]
    #[inline(always)]
    pub fn on_toggle(self) -> &'a mut W {
        self.variant(ACIS_A::ON_TOGGLE)
    }
    #[doc = "Interrupt on Falling Edge"]
    #[inline(always)]
    pub fn on_falling_edge(self) -> &'a mut W {
        self.variant(ACIS_A::ON_FALLING_EDGE)
    }
    #[doc = "Interrupt on Rising Edge"]
    #[inline(always)]
    pub fn on_rising_edge(self) -> &'a mut W {
        self.variant(ACIS_A::ON_RISING_EDGE)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `ACME` reader - Analog Comparator Multiplexer Enable"]
pub struct ACME_R(crate::FieldReader<bool, bool>);
impl ACME_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACME_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACME_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACME` writer - Analog Comparator Multiplexer Enable"]
pub struct ACME_W<'a> {
    w: &'a mut W,
}
impl<'a> ACME_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `ACIE` reader - Analog Comparator Interrupt Enable"]
pub struct ACIE_R(crate::FieldReader<bool, bool>);
impl ACIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACIE` writer - Analog Comparator Interrupt Enable"]
pub struct ACIE_W<'a> {
    w: &'a mut W,
}
impl<'a> ACIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `ACI` reader - Analog Comparator Interrupt Flag"]
pub struct ACI_R(crate::FieldReader<bool, bool>);
impl ACI_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACI` writer - Analog Comparator Interrupt Flag"]
pub struct ACI_W<'a> {
    w: &'a mut W,
}
impl<'a> ACI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `ACO` reader - Analog Compare Output"]
pub struct ACO_R(crate::FieldReader<bool, bool>);
impl ACO_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACO_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACO_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACBG` reader - Analog Comparator Bandgap Select"]
pub struct ACBG_R(crate::FieldReader<bool, bool>);
impl ACBG_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACBG_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACBG_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACBG` writer - Analog Comparator Bandgap Select"]
pub struct ACBG_W<'a> {
    w: &'a mut W,
}
impl<'a> ACBG_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `ACD` reader - Analog Comparator Disable"]
pub struct ACD_R(crate::FieldReader<bool, bool>);
impl ACD_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACD` writer - Analog Comparator Disable"]
pub struct ACD_W<'a> {
    w: &'a mut W,
}
impl<'a> ACD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Analog Comparator Interrupt Mode Select"]
    #[inline(always)]
    pub fn acis(&self) -> ACIS_R {
        ACIS_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bit 2 - Analog Comparator Multiplexer Enable"]
    #[inline(always)]
    pub fn acme(&self) -> ACME_R {
        ACME_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Analog Comparator Interrupt Enable"]
    #[inline(always)]
    pub fn acie(&self) -> ACIE_R {
        ACIE_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Analog Comparator Interrupt Flag"]
    #[inline(always)]
    pub fn aci(&self) -> ACI_R {
        ACI_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Analog Compare Output"]
    #[inline(always)]
    pub fn aco(&self) -> ACO_R {
        ACO_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Analog Comparator Bandgap Select"]
    #[inline(always)]
    pub fn acbg(&self) -> ACBG_R {
        ACBG_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Analog Comparator Disable"]
    #[inline(always)]
    pub fn acd(&self) -> ACD_R {
        ACD_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - Analog Comparator Interrupt Mode Select"]
    #[inline(always)]
    pub fn acis(&mut self) -> ACIS_W {
        ACIS_W { w: self }
    }
    #[doc = "Bit 2 - Analog Comparator Multiplexer Enable"]
    #[inline(always)]
    pub fn acme(&mut self) -> ACME_W {
        ACME_W { w: self }
    }
    #[doc = "Bit 3 - Analog Comparator Interrupt Enable"]
    #[inline(always)]
    pub fn acie(&mut self) -> ACIE_W {
        ACIE_W { w: self }
    }
    #[doc = "Bit 4 - Analog Comparator Interrupt Flag"]
    #[inline(always)]
    pub fn aci(&mut self) -> ACI_W {
        ACI_W { w: self }
    }
    #[doc = "Bit 6 - Analog Comparator Bandgap Select"]
    #[inline(always)]
    pub fn acbg(&mut self) -> ACBG_W {
        ACBG_W { w: self }
    }
    #[doc = "Bit 7 - Analog Comparator Disable"]
    #[inline(always)]
    pub fn acd(&mut self) -> ACD_W {
        ACD_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Analog Comparator Control And Status Register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [acsra](index.html) module"]
pub struct ACSRA_SPEC;
impl crate::RegisterSpec for ACSRA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [acsra::R](R) reader structure"]
impl crate::Readable for ACSRA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [acsra::W](W) writer structure"]
impl crate::Writable for ACSRA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ACSRA to value 0"]
impl crate::Resettable for ACSRA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
