#[doc = "Register `GTCCR` reader"]
pub struct R(crate::R<GTCCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GTCCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GTCCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GTCCR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GTCCR` writer"]
pub struct W(crate::W<GTCCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GTCCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GTCCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GTCCR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PSR1` reader - Prescaler Reset Timer/Counter1"]
pub struct PSR1_R(crate::FieldReader<bool, bool>);
impl PSR1_R {
    pub(crate) fn new(bits: bool) -> Self {
        PSR1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PSR1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PSR1` writer - Prescaler Reset Timer/Counter1"]
pub struct PSR1_W<'a> {
    w: &'a mut W,
}
impl<'a> PSR1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `FOC1A` writer - Force Output Compare 1A"]
pub struct FOC1A_W<'a> {
    w: &'a mut W,
}
impl<'a> FOC1A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `FOC1B` writer - Force Output Compare Match 1B"]
pub struct FOC1B_W<'a> {
    w: &'a mut W,
}
impl<'a> FOC1B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Comparator B Output Mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum COM1B_A {
    #[doc = "0: Normal port operation, OCix disconnected"]
    DISCONNECTED = 0,
    #[doc = "1: Toggle OCix on Compare Match"]
    MATCH_TOGGLE = 1,
    #[doc = "2: Clear OCix on Compare Match"]
    MATCH_CLEAR = 2,
    #[doc = "3: Set OCix on Compare Match"]
    MATCH_SET = 3,
}
impl From<COM1B_A> for u8 {
    #[inline(always)]
    fn from(variant: COM1B_A) -> Self {
        variant as _
    }
}
#[doc = "Field `COM1B` reader - Comparator B Output Mode"]
pub struct COM1B_R(crate::FieldReader<u8, COM1B_A>);
impl COM1B_R {
    pub(crate) fn new(bits: u8) -> Self {
        COM1B_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> COM1B_A {
        match self.bits {
            0 => COM1B_A::DISCONNECTED,
            1 => COM1B_A::MATCH_TOGGLE,
            2 => COM1B_A::MATCH_CLEAR,
            3 => COM1B_A::MATCH_SET,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `DISCONNECTED`"]
    #[inline(always)]
    pub fn is_disconnected(&self) -> bool {
        **self == COM1B_A::DISCONNECTED
    }
    #[doc = "Checks if the value of the field is `MATCH_TOGGLE`"]
    #[inline(always)]
    pub fn is_match_toggle(&self) -> bool {
        **self == COM1B_A::MATCH_TOGGLE
    }
    #[doc = "Checks if the value of the field is `MATCH_CLEAR`"]
    #[inline(always)]
    pub fn is_match_clear(&self) -> bool {
        **self == COM1B_A::MATCH_CLEAR
    }
    #[doc = "Checks if the value of the field is `MATCH_SET`"]
    #[inline(always)]
    pub fn is_match_set(&self) -> bool {
        **self == COM1B_A::MATCH_SET
    }
}
impl core::ops::Deref for COM1B_R {
    type Target = crate::FieldReader<u8, COM1B_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COM1B` writer - Comparator B Output Mode"]
pub struct COM1B_W<'a> {
    w: &'a mut W,
}
impl<'a> COM1B_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: COM1B_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Normal port operation, OCix disconnected"]
    #[inline(always)]
    pub fn disconnected(self) -> &'a mut W {
        self.variant(COM1B_A::DISCONNECTED)
    }
    #[doc = "Toggle OCix on Compare Match"]
    #[inline(always)]
    pub fn match_toggle(self) -> &'a mut W {
        self.variant(COM1B_A::MATCH_TOGGLE)
    }
    #[doc = "Clear OCix on Compare Match"]
    #[inline(always)]
    pub fn match_clear(self) -> &'a mut W {
        self.variant(COM1B_A::MATCH_CLEAR)
    }
    #[doc = "Set OCix on Compare Match"]
    #[inline(always)]
    pub fn match_set(self) -> &'a mut W {
        self.variant(COM1B_A::MATCH_SET)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `PWM1B` reader - Pulse Width Modulator B Enable"]
pub struct PWM1B_R(crate::FieldReader<bool, bool>);
impl PWM1B_R {
    pub(crate) fn new(bits: bool) -> Self {
        PWM1B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PWM1B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PWM1B` writer - Pulse Width Modulator B Enable"]
pub struct PWM1B_W<'a> {
    w: &'a mut W,
}
impl<'a> PWM1B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 1 - Prescaler Reset Timer/Counter1"]
    #[inline(always)]
    pub fn psr1(&self) -> PSR1_R {
        PSR1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bits 4:5 - Comparator B Output Mode"]
    #[inline(always)]
    pub fn com1b(&self) -> COM1B_R {
        COM1B_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bit 6 - Pulse Width Modulator B Enable"]
    #[inline(always)]
    pub fn pwm1b(&self) -> PWM1B_R {
        PWM1B_R::new(((self.bits >> 6) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 1 - Prescaler Reset Timer/Counter1"]
    #[inline(always)]
    pub fn psr1(&mut self) -> PSR1_W {
        PSR1_W { w: self }
    }
    #[doc = "Bit 2 - Force Output Compare 1A"]
    #[inline(always)]
    pub fn foc1a(&mut self) -> FOC1A_W {
        FOC1A_W { w: self }
    }
    #[doc = "Bit 3 - Force Output Compare Match 1B"]
    #[inline(always)]
    pub fn foc1b(&mut self) -> FOC1B_W {
        FOC1B_W { w: self }
    }
    #[doc = "Bits 4:5 - Comparator B Output Mode"]
    #[inline(always)]
    pub fn com1b(&mut self) -> COM1B_W {
        COM1B_W { w: self }
    }
    #[doc = "Bit 6 - Pulse Width Modulator B Enable"]
    #[inline(always)]
    pub fn pwm1b(&mut self) -> PWM1B_W {
        PWM1B_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer counter control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gtccr](index.html) module"]
pub struct GTCCR_SPEC;
impl crate::RegisterSpec for GTCCR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [gtccr::R](R) reader structure"]
impl crate::Readable for GTCCR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gtccr::W](W) writer structure"]
impl crate::Writable for GTCCR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GTCCR to value 0"]
impl crate::Resettable for GTCCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
