#[doc = "Register `DTPS` reader"]
pub struct R(crate::R<DTPS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DTPS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DTPS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DTPS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DTPS` writer"]
pub struct W(crate::W<DTPS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DTPS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DTPS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DTPS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "No Description.\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum DTPS_A {
    #[doc = "0: No Prescaling"]
    DIRECT = 0,
    #[doc = "1: Division factor 2"]
    PRESCALE_2 = 1,
    #[doc = "2: Division factor 4"]
    PRESCALE_4 = 2,
    #[doc = "3: Division factor 8"]
    PRESCALE_8 = 3,
}
impl From<DTPS_A> for u8 {
    #[inline(always)]
    fn from(variant: DTPS_A) -> Self {
        variant as _
    }
}
#[doc = "Field `DTPS` reader - No Description."]
pub struct DTPS_R(crate::FieldReader<u8, DTPS_A>);
impl DTPS_R {
    pub(crate) fn new(bits: u8) -> Self {
        DTPS_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> DTPS_A {
        match self.bits {
            0 => DTPS_A::DIRECT,
            1 => DTPS_A::PRESCALE_2,
            2 => DTPS_A::PRESCALE_4,
            3 => DTPS_A::PRESCALE_8,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `DIRECT`"]
    #[inline(always)]
    pub fn is_direct(&self) -> bool {
        **self == DTPS_A::DIRECT
    }
    #[doc = "Checks if the value of the field is `PRESCALE_2`"]
    #[inline(always)]
    pub fn is_prescale_2(&self) -> bool {
        **self == DTPS_A::PRESCALE_2
    }
    #[doc = "Checks if the value of the field is `PRESCALE_4`"]
    #[inline(always)]
    pub fn is_prescale_4(&self) -> bool {
        **self == DTPS_A::PRESCALE_4
    }
    #[doc = "Checks if the value of the field is `PRESCALE_8`"]
    #[inline(always)]
    pub fn is_prescale_8(&self) -> bool {
        **self == DTPS_A::PRESCALE_8
    }
}
impl core::ops::Deref for DTPS_R {
    type Target = crate::FieldReader<u8, DTPS_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTPS` writer - No Description."]
pub struct DTPS_W<'a> {
    w: &'a mut W,
}
impl<'a> DTPS_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: DTPS_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "No Prescaling"]
    #[inline(always)]
    pub fn direct(self) -> &'a mut W {
        self.variant(DTPS_A::DIRECT)
    }
    #[doc = "Division factor 2"]
    #[inline(always)]
    pub fn prescale_2(self) -> &'a mut W {
        self.variant(DTPS_A::PRESCALE_2)
    }
    #[doc = "Division factor 4"]
    #[inline(always)]
    pub fn prescale_4(self) -> &'a mut W {
        self.variant(DTPS_A::PRESCALE_4)
    }
    #[doc = "Division factor 8"]
    #[inline(always)]
    pub fn prescale_8(self) -> &'a mut W {
        self.variant(DTPS_A::PRESCALE_8)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - No Description."]
    #[inline(always)]
    pub fn dtps(&self) -> DTPS_R {
        DTPS_R::new((self.bits & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:1 - No Description."]
    #[inline(always)]
    pub fn dtps(&mut self) -> DTPS_W {
        DTPS_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Dead time prescaler register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [dtps](index.html) module"]
pub struct DTPS_SPEC;
impl crate::RegisterSpec for DTPS_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [dtps::R](R) reader structure"]
impl crate::Readable for DTPS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [dtps::W](W) writer structure"]
impl crate::Writable for DTPS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DTPS to value 0"]
impl crate::Resettable for DTPS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
