#[doc = "Register `UCSR1D` reader"]
pub struct R(crate::R<UCSR1D_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UCSR1D_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UCSR1D_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UCSR1D_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UCSR1D` writer"]
pub struct W(crate::W<UCSR1D_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UCSR1D_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UCSR1D_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UCSR1D_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SFDE1` reader - USART RX Start Frame Detection Enable"]
pub struct SFDE1_R(crate::FieldReader<bool, bool>);
impl SFDE1_R {
    pub(crate) fn new(bits: bool) -> Self {
        SFDE1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SFDE1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SFDE1` writer - USART RX Start Frame Detection Enable"]
pub struct SFDE1_W<'a> {
    w: &'a mut W,
}
impl<'a> SFDE1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `RXS1` reader - USART RX Start Flag"]
pub struct RXS1_R(crate::FieldReader<bool, bool>);
impl RXS1_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXS1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXS1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXS1` writer - USART RX Start Flag"]
pub struct RXS1_W<'a> {
    w: &'a mut W,
}
impl<'a> RXS1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RXSIE1` reader - USART RX Start Interrupt Enable"]
pub struct RXSIE1_R(crate::FieldReader<bool, bool>);
impl RXSIE1_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXSIE1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXSIE1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXSIE1` writer - USART RX Start Interrupt Enable"]
pub struct RXSIE1_W<'a> {
    w: &'a mut W,
}
impl<'a> RXSIE1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 5 - USART RX Start Frame Detection Enable"]
    #[inline(always)]
    pub fn sfde1(&self) -> SFDE1_R {
        SFDE1_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - USART RX Start Flag"]
    #[inline(always)]
    pub fn rxs1(&self) -> RXS1_R {
        RXS1_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - USART RX Start Interrupt Enable"]
    #[inline(always)]
    pub fn rxsie1(&self) -> RXSIE1_R {
        RXSIE1_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 5 - USART RX Start Frame Detection Enable"]
    #[inline(always)]
    pub fn sfde1(&mut self) -> SFDE1_W {
        SFDE1_W { w: self }
    }
    #[doc = "Bit 6 - USART RX Start Flag"]
    #[inline(always)]
    pub fn rxs1(&mut self) -> RXS1_W {
        RXS1_W { w: self }
    }
    #[doc = "Bit 7 - USART RX Start Interrupt Enable"]
    #[inline(always)]
    pub fn rxsie1(&mut self) -> RXSIE1_W {
        RXSIE1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USART Control and Status Register D\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ucsr1d](index.html) module"]
pub struct UCSR1D_SPEC;
impl crate::RegisterSpec for UCSR1D_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ucsr1d::R](R) reader structure"]
impl crate::Readable for UCSR1D_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ucsr1d::W](W) writer structure"]
impl crate::Writable for UCSR1D_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UCSR1D to value 0"]
impl crate::Resettable for UCSR1D_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
