#[doc = "Register `REMAP` reader"]
pub struct R(crate::R<REMAP_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<REMAP_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<REMAP_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<REMAP_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `REMAP` writer"]
pub struct W(crate::W<REMAP_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<REMAP_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<REMAP_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<REMAP_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `U0MAP` reader - USART0 Pin Mapping"]
pub struct U0MAP_R(crate::FieldReader<bool, bool>);
impl U0MAP_R {
    pub(crate) fn new(bits: bool) -> Self {
        U0MAP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for U0MAP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `U0MAP` writer - USART0 Pin Mapping"]
pub struct U0MAP_W<'a> {
    w: &'a mut W,
}
impl<'a> U0MAP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - USART0 Pin Mapping"]
    #[inline(always)]
    pub fn u0map(&self) -> U0MAP_R {
        U0MAP_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - USART0 Pin Mapping"]
    #[inline(always)]
    pub fn u0map(&mut self) -> U0MAP_W {
        U0MAP_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Remap Port Pins\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [remap](index.html) module"]
pub struct REMAP_SPEC;
impl crate::RegisterSpec for REMAP_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [remap::R](R) reader structure"]
impl crate::Readable for REMAP_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [remap::W](W) writer structure"]
impl crate::Writable for REMAP_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets REMAP to value 0"]
impl crate::Resettable for REMAP_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
