#[doc = "Register `TWSD` reader"]
pub struct R(crate::R<TWSD_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TWSD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TWSD_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TWSD_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TWSD` writer"]
pub struct W(crate::W<TWSD_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TWSD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TWSD_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TWSD_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TWSD` reader - TWI slave data bit"]
pub struct TWSD_R(crate::FieldReader<u8, u8>);
impl TWSD_R {
    pub(crate) fn new(bits: u8) -> Self {
        TWSD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWSD_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWSD` writer - TWI slave data bit"]
pub struct TWSD_W<'a> {
    w: &'a mut W,
}
impl<'a> TWSD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - TWI slave data bit"]
    #[inline(always)]
    pub fn twsd(&self) -> TWSD_R {
        TWSD_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - TWI slave data bit"]
    #[inline(always)]
    pub fn twsd(&mut self) -> TWSD_W {
        TWSD_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "TWI Slave Data Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [twsd](index.html) module"]
pub struct TWSD_SPEC;
impl crate::RegisterSpec for TWSD_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [twsd::R](R) reader structure"]
impl crate::Readable for TWSD_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [twsd::W](W) writer structure"]
impl crate::Writable for TWSD_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TWSD to value 0"]
impl crate::Resettable for TWSD_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
