#[doc = "Register `TWSCRB` reader"]
pub struct R(crate::R<TWSCRB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TWSCRB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TWSCRB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TWSCRB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TWSCRB` writer"]
pub struct W(crate::W<TWSCRB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TWSCRB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TWSCRB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TWSCRB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TWCMD` reader - No Description."]
pub struct TWCMD_R(crate::FieldReader<u8, u8>);
impl TWCMD_R {
    pub(crate) fn new(bits: u8) -> Self {
        TWCMD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWCMD_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWCMD` writer - No Description."]
pub struct TWCMD_W<'a> {
    w: &'a mut W,
}
impl<'a> TWCMD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "TWI Acknowledge Action\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum TWAA_A {
    #[doc = "0: Send ACK (timing depends on `TWSME`)"]
    SEND_ACK = 0,
    #[doc = "1: Send NACK (timing depends on `TWSME`)"]
    SEND_NACK = 1,
}
impl From<TWAA_A> for bool {
    #[inline(always)]
    fn from(variant: TWAA_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `TWAA` reader - TWI Acknowledge Action"]
pub struct TWAA_R(crate::FieldReader<bool, TWAA_A>);
impl TWAA_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWAA_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> TWAA_A {
        match self.bits {
            false => TWAA_A::SEND_ACK,
            true => TWAA_A::SEND_NACK,
        }
    }
    #[doc = "Checks if the value of the field is `SEND_ACK`"]
    #[inline(always)]
    pub fn is_send_ack(&self) -> bool {
        **self == TWAA_A::SEND_ACK
    }
    #[doc = "Checks if the value of the field is `SEND_NACK`"]
    #[inline(always)]
    pub fn is_send_nack(&self) -> bool {
        **self == TWAA_A::SEND_NACK
    }
}
impl core::ops::Deref for TWAA_R {
    type Target = crate::FieldReader<bool, TWAA_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWAA` writer - TWI Acknowledge Action"]
pub struct TWAA_W<'a> {
    w: &'a mut W,
}
impl<'a> TWAA_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TWAA_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Send ACK (timing depends on `TWSME`)"]
    #[inline(always)]
    pub fn send_ack(self) -> &'a mut W {
        self.variant(TWAA_A::SEND_ACK)
    }
    #[doc = "Send NACK (timing depends on `TWSME`)"]
    #[inline(always)]
    pub fn send_nack(self) -> &'a mut W {
        self.variant(TWAA_A::SEND_NACK)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `TWHNM` reader - TWI High Noise Mode"]
pub struct TWHNM_R(crate::FieldReader<bool, bool>);
impl TWHNM_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWHNM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWHNM_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWHNM` writer - TWI High Noise Mode"]
pub struct TWHNM_W<'a> {
    w: &'a mut W,
}
impl<'a> TWHNM_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - No Description."]
    #[inline(always)]
    pub fn twcmd(&self) -> TWCMD_R {
        TWCMD_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bit 2 - TWI Acknowledge Action"]
    #[inline(always)]
    pub fn twaa(&self) -> TWAA_R {
        TWAA_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - TWI High Noise Mode"]
    #[inline(always)]
    pub fn twhnm(&self) -> TWHNM_R {
        TWHNM_R::new(((self.bits >> 3) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - No Description."]
    #[inline(always)]
    pub fn twcmd(&mut self) -> TWCMD_W {
        TWCMD_W { w: self }
    }
    #[doc = "Bit 2 - TWI Acknowledge Action"]
    #[inline(always)]
    pub fn twaa(&mut self) -> TWAA_W {
        TWAA_W { w: self }
    }
    #[doc = "Bit 3 - TWI High Noise Mode"]
    #[inline(always)]
    pub fn twhnm(&mut self) -> TWHNM_W {
        TWHNM_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "TWI Slave Control Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [twscrb](index.html) module"]
pub struct TWSCRB_SPEC;
impl crate::RegisterSpec for TWSCRB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [twscrb::R](R) reader structure"]
impl crate::Readable for TWSCRB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [twscrb::W](W) writer structure"]
impl crate::Writable for TWSCRB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TWSCRB to value 0"]
impl crate::Resettable for TWSCRB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
