#[doc = "Register `TWSCRA` reader"]
pub struct R(crate::R<TWSCRA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TWSCRA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TWSCRA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TWSCRA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TWSCRA` writer"]
pub struct W(crate::W<TWSCRA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TWSCRA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TWSCRA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TWSCRA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TWSME` reader - TWI Smart Mode Enable"]
pub struct TWSME_R(crate::FieldReader<bool, bool>);
impl TWSME_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWSME_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWSME_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWSME` writer - TWI Smart Mode Enable"]
pub struct TWSME_W<'a> {
    w: &'a mut W,
}
impl<'a> TWSME_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `TWPME` reader - TWI Promiscuous Mode Enable"]
pub struct TWPME_R(crate::FieldReader<bool, bool>);
impl TWPME_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWPME_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWPME_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWPME` writer - TWI Promiscuous Mode Enable"]
pub struct TWPME_W<'a> {
    w: &'a mut W,
}
impl<'a> TWPME_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `TWSIE` reader - TWI Stop Interrupt Enable"]
pub struct TWSIE_R(crate::FieldReader<bool, bool>);
impl TWSIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWSIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWSIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWSIE` writer - TWI Stop Interrupt Enable"]
pub struct TWSIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TWSIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `TWEN` reader - Two-Wire Interface Enable"]
pub struct TWEN_R(crate::FieldReader<bool, bool>);
impl TWEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWEN` writer - Two-Wire Interface Enable"]
pub struct TWEN_W<'a> {
    w: &'a mut W,
}
impl<'a> TWEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `TWASIE` reader - TWI Address/Stop Interrupt Enable"]
pub struct TWASIE_R(crate::FieldReader<bool, bool>);
impl TWASIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWASIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWASIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWASIE` writer - TWI Address/Stop Interrupt Enable"]
pub struct TWASIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TWASIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `TWDIE` reader - TWI Data Interrupt Enable"]
pub struct TWDIE_R(crate::FieldReader<bool, bool>);
impl TWDIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWDIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWDIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWDIE` writer - TWI Data Interrupt Enable"]
pub struct TWDIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TWDIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `TWSHE` reader - TWI SDA Hold Time Enable"]
pub struct TWSHE_R(crate::FieldReader<bool, bool>);
impl TWSHE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWSHE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWSHE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWSHE` writer - TWI SDA Hold Time Enable"]
pub struct TWSHE_W<'a> {
    w: &'a mut W,
}
impl<'a> TWSHE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - TWI Smart Mode Enable"]
    #[inline(always)]
    pub fn twsme(&self) -> TWSME_R {
        TWSME_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - TWI Promiscuous Mode Enable"]
    #[inline(always)]
    pub fn twpme(&self) -> TWPME_R {
        TWPME_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - TWI Stop Interrupt Enable"]
    #[inline(always)]
    pub fn twsie(&self) -> TWSIE_R {
        TWSIE_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Two-Wire Interface Enable"]
    #[inline(always)]
    pub fn twen(&self) -> TWEN_R {
        TWEN_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - TWI Address/Stop Interrupt Enable"]
    #[inline(always)]
    pub fn twasie(&self) -> TWASIE_R {
        TWASIE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - TWI Data Interrupt Enable"]
    #[inline(always)]
    pub fn twdie(&self) -> TWDIE_R {
        TWDIE_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 7 - TWI SDA Hold Time Enable"]
    #[inline(always)]
    pub fn twshe(&self) -> TWSHE_R {
        TWSHE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - TWI Smart Mode Enable"]
    #[inline(always)]
    pub fn twsme(&mut self) -> TWSME_W {
        TWSME_W { w: self }
    }
    #[doc = "Bit 1 - TWI Promiscuous Mode Enable"]
    #[inline(always)]
    pub fn twpme(&mut self) -> TWPME_W {
        TWPME_W { w: self }
    }
    #[doc = "Bit 2 - TWI Stop Interrupt Enable"]
    #[inline(always)]
    pub fn twsie(&mut self) -> TWSIE_W {
        TWSIE_W { w: self }
    }
    #[doc = "Bit 3 - Two-Wire Interface Enable"]
    #[inline(always)]
    pub fn twen(&mut self) -> TWEN_W {
        TWEN_W { w: self }
    }
    #[doc = "Bit 4 - TWI Address/Stop Interrupt Enable"]
    #[inline(always)]
    pub fn twasie(&mut self) -> TWASIE_W {
        TWASIE_W { w: self }
    }
    #[doc = "Bit 5 - TWI Data Interrupt Enable"]
    #[inline(always)]
    pub fn twdie(&mut self) -> TWDIE_W {
        TWDIE_W { w: self }
    }
    #[doc = "Bit 7 - TWI SDA Hold Time Enable"]
    #[inline(always)]
    pub fn twshe(&mut self) -> TWSHE_W {
        TWSHE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "TWI Slave Control Register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [twscra](index.html) module"]
pub struct TWSCRA_SPEC;
impl crate::RegisterSpec for TWSCRA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [twscra::R](R) reader structure"]
impl crate::Readable for TWSCRA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [twscra::W](W) writer structure"]
impl crate::Writable for TWSCRA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TWSCRA to value 0"]
impl crate::Resettable for TWSCRA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
