#[doc = "Register `TOCPMSA0` reader"]
pub struct R(crate::R<TOCPMSA0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TOCPMSA0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TOCPMSA0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TOCPMSA0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TOCPMSA0` writer"]
pub struct W(crate::W<TOCPMSA0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TOCPMSA0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TOCPMSA0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TOCPMSA0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TOCC0S` reader - Timer Output Compare Channel 0 Selection Bits"]
pub struct TOCC0S_R(crate::FieldReader<u8, u8>);
impl TOCC0S_R {
    pub(crate) fn new(bits: u8) -> Self {
        TOCC0S_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOCC0S_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOCC0S` writer - Timer Output Compare Channel 0 Selection Bits"]
pub struct TOCC0S_W<'a> {
    w: &'a mut W,
}
impl<'a> TOCC0S_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `TOCC1S` reader - Timer Output Compare Channel 1 Selection Bits"]
pub struct TOCC1S_R(crate::FieldReader<u8, u8>);
impl TOCC1S_R {
    pub(crate) fn new(bits: u8) -> Self {
        TOCC1S_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOCC1S_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOCC1S` writer - Timer Output Compare Channel 1 Selection Bits"]
pub struct TOCC1S_W<'a> {
    w: &'a mut W,
}
impl<'a> TOCC1S_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u8 & 0x03) << 2);
        self.w
    }
}
#[doc = "Field `TOCC2S` reader - Timer Output Compare Channel 2 Selection Bits"]
pub struct TOCC2S_R(crate::FieldReader<u8, u8>);
impl TOCC2S_R {
    pub(crate) fn new(bits: u8) -> Self {
        TOCC2S_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOCC2S_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOCC2S` writer - Timer Output Compare Channel 2 Selection Bits"]
pub struct TOCC2S_W<'a> {
    w: &'a mut W,
}
impl<'a> TOCC2S_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `TOCC3S` reader - Timer Output Compare Channel 3 Selection Bits"]
pub struct TOCC3S_R(crate::FieldReader<u8, u8>);
impl TOCC3S_R {
    pub(crate) fn new(bits: u8) -> Self {
        TOCC3S_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOCC3S_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOCC3S` writer - Timer Output Compare Channel 3 Selection Bits"]
pub struct TOCC3S_W<'a> {
    w: &'a mut W,
}
impl<'a> TOCC3S_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Timer Output Compare Channel 0 Selection Bits"]
    #[inline(always)]
    pub fn tocc0s(&self) -> TOCC0S_R {
        TOCC0S_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - Timer Output Compare Channel 1 Selection Bits"]
    #[inline(always)]
    pub fn tocc1s(&self) -> TOCC1S_R {
        TOCC1S_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 4:5 - Timer Output Compare Channel 2 Selection Bits"]
    #[inline(always)]
    pub fn tocc2s(&self) -> TOCC2S_R {
        TOCC2S_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 6:7 - Timer Output Compare Channel 3 Selection Bits"]
    #[inline(always)]
    pub fn tocc3s(&self) -> TOCC3S_R {
        TOCC3S_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:1 - Timer Output Compare Channel 0 Selection Bits"]
    #[inline(always)]
    pub fn tocc0s(&mut self) -> TOCC0S_W {
        TOCC0S_W { w: self }
    }
    #[doc = "Bits 2:3 - Timer Output Compare Channel 1 Selection Bits"]
    #[inline(always)]
    pub fn tocc1s(&mut self) -> TOCC1S_W {
        TOCC1S_W { w: self }
    }
    #[doc = "Bits 4:5 - Timer Output Compare Channel 2 Selection Bits"]
    #[inline(always)]
    pub fn tocc2s(&mut self) -> TOCC2S_W {
        TOCC2S_W { w: self }
    }
    #[doc = "Bits 6:7 - Timer Output Compare Channel 3 Selection Bits"]
    #[inline(always)]
    pub fn tocc3s(&mut self) -> TOCC3S_W {
        TOCC3S_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer Output Compare Pin Mux Selection 0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tocpmsa0](index.html) module"]
pub struct TOCPMSA0_SPEC;
impl crate::RegisterSpec for TOCPMSA0_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tocpmsa0::R](R) reader structure"]
impl crate::Readable for TOCPMSA0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tocpmsa0::W](W) writer structure"]
impl crate::Writable for TOCPMSA0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TOCPMSA0 to value 0"]
impl crate::Resettable for TOCPMSA0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
