#[doc = "Register `TCCR2B` reader"]
pub struct R(crate::R<TCCR2B_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR2B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR2B_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR2B_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR2B` writer"]
pub struct W(crate::W<TCCR2B_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR2B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR2B_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR2B_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Clock Select bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CS2_A {
    #[doc = "0: No clock source (Timer/Counter stopped)"]
    NO_CLOCK = 0,
    #[doc = "1: Running, No Prescaling"]
    DIRECT = 1,
    #[doc = "2: Running, CLK/8"]
    PRESCALE_8 = 2,
    #[doc = "3: Running, CLK/64"]
    PRESCALE_64 = 3,
    #[doc = "4: Running, CLK/256"]
    PRESCALE_256 = 4,
    #[doc = "5: Running, CLK/1024"]
    PRESCALE_1024 = 5,
    #[doc = "6: Running, ExtClk Tx Falling Edge"]
    EXT_FALLING = 6,
    #[doc = "7: Running, ExtClk Tx Rising Edge"]
    EXT_RISING = 7,
}
impl From<CS2_A> for u8 {
    #[inline(always)]
    fn from(variant: CS2_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CS2` reader - Clock Select bits"]
pub struct CS2_R(crate::FieldReader<u8, CS2_A>);
impl CS2_R {
    pub(crate) fn new(bits: u8) -> Self {
        CS2_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CS2_A {
        match self.bits {
            0 => CS2_A::NO_CLOCK,
            1 => CS2_A::DIRECT,
            2 => CS2_A::PRESCALE_8,
            3 => CS2_A::PRESCALE_64,
            4 => CS2_A::PRESCALE_256,
            5 => CS2_A::PRESCALE_1024,
            6 => CS2_A::EXT_FALLING,
            7 => CS2_A::EXT_RISING,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NO_CLOCK`"]
    #[inline(always)]
    pub fn is_no_clock(&self) -> bool {
        **self == CS2_A::NO_CLOCK
    }
    #[doc = "Checks if the value of the field is `DIRECT`"]
    #[inline(always)]
    pub fn is_direct(&self) -> bool {
        **self == CS2_A::DIRECT
    }
    #[doc = "Checks if the value of the field is `PRESCALE_8`"]
    #[inline(always)]
    pub fn is_prescale_8(&self) -> bool {
        **self == CS2_A::PRESCALE_8
    }
    #[doc = "Checks if the value of the field is `PRESCALE_64`"]
    #[inline(always)]
    pub fn is_prescale_64(&self) -> bool {
        **self == CS2_A::PRESCALE_64
    }
    #[doc = "Checks if the value of the field is `PRESCALE_256`"]
    #[inline(always)]
    pub fn is_prescale_256(&self) -> bool {
        **self == CS2_A::PRESCALE_256
    }
    #[doc = "Checks if the value of the field is `PRESCALE_1024`"]
    #[inline(always)]
    pub fn is_prescale_1024(&self) -> bool {
        **self == CS2_A::PRESCALE_1024
    }
    #[doc = "Checks if the value of the field is `EXT_FALLING`"]
    #[inline(always)]
    pub fn is_ext_falling(&self) -> bool {
        **self == CS2_A::EXT_FALLING
    }
    #[doc = "Checks if the value of the field is `EXT_RISING`"]
    #[inline(always)]
    pub fn is_ext_rising(&self) -> bool {
        **self == CS2_A::EXT_RISING
    }
}
impl core::ops::Deref for CS2_R {
    type Target = crate::FieldReader<u8, CS2_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CS2` writer - Clock Select bits"]
pub struct CS2_W<'a> {
    w: &'a mut W,
}
impl<'a> CS2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CS2_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "No clock source (Timer/Counter stopped)"]
    #[inline(always)]
    pub fn no_clock(self) -> &'a mut W {
        self.variant(CS2_A::NO_CLOCK)
    }
    #[doc = "Running, No Prescaling"]
    #[inline(always)]
    pub fn direct(self) -> &'a mut W {
        self.variant(CS2_A::DIRECT)
    }
    #[doc = "Running, CLK/8"]
    #[inline(always)]
    pub fn prescale_8(self) -> &'a mut W {
        self.variant(CS2_A::PRESCALE_8)
    }
    #[doc = "Running, CLK/64"]
    #[inline(always)]
    pub fn prescale_64(self) -> &'a mut W {
        self.variant(CS2_A::PRESCALE_64)
    }
    #[doc = "Running, CLK/256"]
    #[inline(always)]
    pub fn prescale_256(self) -> &'a mut W {
        self.variant(CS2_A::PRESCALE_256)
    }
    #[doc = "Running, CLK/1024"]
    #[inline(always)]
    pub fn prescale_1024(self) -> &'a mut W {
        self.variant(CS2_A::PRESCALE_1024)
    }
    #[doc = "Running, ExtClk Tx Falling Edge"]
    #[inline(always)]
    pub fn ext_falling(self) -> &'a mut W {
        self.variant(CS2_A::EXT_FALLING)
    }
    #[doc = "Running, ExtClk Tx Rising Edge"]
    #[inline(always)]
    pub fn ext_rising(self) -> &'a mut W {
        self.variant(CS2_A::EXT_RISING)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `WGM2` reader - Waveform Generation Mode Bits"]
pub struct WGM2_R(crate::FieldReader<u8, u8>);
impl WGM2_R {
    pub(crate) fn new(bits: u8) -> Self {
        WGM2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WGM2_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM2` writer - Waveform Generation Mode Bits"]
pub struct WGM2_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM2_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 3)) | ((value as u8 & 0x03) << 3);
        self.w
    }
}
#[doc = "Field `ICES2` reader - Input Capture 2 Edge Select"]
pub struct ICES2_R(crate::FieldReader<bool, bool>);
impl ICES2_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICES2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICES2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICES2` writer - Input Capture 2 Edge Select"]
pub struct ICES2_W<'a> {
    w: &'a mut W,
}
impl<'a> ICES2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `ICNC2` reader - Input Capture 2 Noise Canceler"]
pub struct ICNC2_R(crate::FieldReader<bool, bool>);
impl ICNC2_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICNC2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICNC2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICNC2` writer - Input Capture 2 Noise Canceler"]
pub struct ICNC2_W<'a> {
    w: &'a mut W,
}
impl<'a> ICNC2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Clock Select bits"]
    #[inline(always)]
    pub fn cs2(&self) -> CS2_R {
        CS2_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bits 3:4 - Waveform Generation Mode Bits"]
    #[inline(always)]
    pub fn wgm2(&self) -> WGM2_R {
        WGM2_R::new(((self.bits >> 3) & 0x03) as u8)
    }
    #[doc = "Bit 6 - Input Capture 2 Edge Select"]
    #[inline(always)]
    pub fn ices2(&self) -> ICES2_R {
        ICES2_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Input Capture 2 Noise Canceler"]
    #[inline(always)]
    pub fn icnc2(&self) -> ICNC2_R {
        ICNC2_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - Clock Select bits"]
    #[inline(always)]
    pub fn cs2(&mut self) -> CS2_W {
        CS2_W { w: self }
    }
    #[doc = "Bits 3:4 - Waveform Generation Mode Bits"]
    #[inline(always)]
    pub fn wgm2(&mut self) -> WGM2_W {
        WGM2_W { w: self }
    }
    #[doc = "Bit 6 - Input Capture 2 Edge Select"]
    #[inline(always)]
    pub fn ices2(&mut self) -> ICES2_W {
        ICES2_W { w: self }
    }
    #[doc = "Bit 7 - Input Capture 2 Noise Canceler"]
    #[inline(always)]
    pub fn icnc2(&mut self) -> ICNC2_W {
        ICNC2_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter2 Control Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr2b](index.html) module"]
pub struct TCCR2B_SPEC;
impl crate::RegisterSpec for TCCR2B_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr2b::R](R) reader structure"]
impl crate::Readable for TCCR2B_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr2b::W](W) writer structure"]
impl crate::Writable for TCCR2B_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR2B to value 0"]
impl crate::Resettable for TCCR2B_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
