#[doc = "Register `PORTCR` reader"]
pub struct R(crate::R<PORTCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PORTCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PORTCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PORTCR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PORTCR` writer"]
pub struct W(crate::W<PORTCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PORTCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PORTCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PORTCR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `BBMA` reader - Break-Before-Make Mode Enable"]
pub struct BBMA_R(crate::FieldReader<bool, bool>);
impl BBMA_R {
    pub(crate) fn new(bits: bool) -> Self {
        BBMA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BBMA_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BBMA` writer - Break-Before-Make Mode Enable"]
pub struct BBMA_W<'a> {
    w: &'a mut W,
}
impl<'a> BBMA_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Break-Before-Make Mode Enable"]
    #[inline(always)]
    pub fn bbma(&self) -> BBMA_R {
        BBMA_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Break-Before-Make Mode Enable"]
    #[inline(always)]
    pub fn bbma(&mut self) -> BBMA_W {
        BBMA_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Port Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [portcr](index.html) module"]
pub struct PORTCR_SPEC;
impl crate::RegisterSpec for PORTCR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [portcr::R](R) reader structure"]
impl crate::Readable for PORTCR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [portcr::W](W) writer structure"]
impl crate::Writable for PORTCR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PORTCR to value 0"]
impl crate::Resettable for PORTCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
