#[doc = "Register `PCMSK1` reader"]
pub struct R(crate::R<PCMSK1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PCMSK1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PCMSK1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PCMSK1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PCMSK1` writer"]
pub struct W(crate::W<PCMSK1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PCMSK1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PCMSK1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PCMSK1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PCINT8` reader - Pin Change Enable Mask 1 Bit 0"]
pub struct PCINT8_R(crate::FieldReader<bool, bool>);
impl PCINT8_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCINT8_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCINT8_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCINT8` writer - Pin Change Enable Mask 1 Bit 0"]
pub struct PCINT8_W<'a> {
    w: &'a mut W,
}
impl<'a> PCINT8_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `PCINT9` reader - Pin Change Enable Mask 1 Bit 1"]
pub struct PCINT9_R(crate::FieldReader<bool, bool>);
impl PCINT9_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCINT9_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCINT9_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCINT9` writer - Pin Change Enable Mask 1 Bit 1"]
pub struct PCINT9_W<'a> {
    w: &'a mut W,
}
impl<'a> PCINT9_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `PCINT10` reader - Pin Change Enable Mask 1 Bit 2"]
pub struct PCINT10_R(crate::FieldReader<bool, bool>);
impl PCINT10_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCINT10_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCINT10_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCINT10` writer - Pin Change Enable Mask 1 Bit 2"]
pub struct PCINT10_W<'a> {
    w: &'a mut W,
}
impl<'a> PCINT10_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `PCINT11` reader - Pin Change Enable Mask 1 Bit 3"]
pub struct PCINT11_R(crate::FieldReader<bool, bool>);
impl PCINT11_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCINT11_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCINT11_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCINT11` writer - Pin Change Enable Mask 1 Bit 3"]
pub struct PCINT11_W<'a> {
    w: &'a mut W,
}
impl<'a> PCINT11_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Pin Change Enable Mask 1 Bit 0"]
    #[inline(always)]
    pub fn pcint8(&self) -> PCINT8_R {
        PCINT8_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Pin Change Enable Mask 1 Bit 1"]
    #[inline(always)]
    pub fn pcint9(&self) -> PCINT9_R {
        PCINT9_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Pin Change Enable Mask 1 Bit 2"]
    #[inline(always)]
    pub fn pcint10(&self) -> PCINT10_R {
        PCINT10_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Pin Change Enable Mask 1 Bit 3"]
    #[inline(always)]
    pub fn pcint11(&self) -> PCINT11_R {
        PCINT11_R::new(((self.bits >> 3) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Pin Change Enable Mask 1 Bit 0"]
    #[inline(always)]
    pub fn pcint8(&mut self) -> PCINT8_W {
        PCINT8_W { w: self }
    }
    #[doc = "Bit 1 - Pin Change Enable Mask 1 Bit 1"]
    #[inline(always)]
    pub fn pcint9(&mut self) -> PCINT9_W {
        PCINT9_W { w: self }
    }
    #[doc = "Bit 2 - Pin Change Enable Mask 1 Bit 2"]
    #[inline(always)]
    pub fn pcint10(&mut self) -> PCINT10_W {
        PCINT10_W { w: self }
    }
    #[doc = "Bit 3 - Pin Change Enable Mask 1 Bit 3"]
    #[inline(always)]
    pub fn pcint11(&mut self) -> PCINT11_W {
        PCINT11_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Pin Change Enable Mask 1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pcmsk1](index.html) module"]
pub struct PCMSK1_SPEC;
impl crate::RegisterSpec for PCMSK1_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [pcmsk1::R](R) reader structure"]
impl crate::Readable for PCMSK1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [pcmsk1::W](W) writer structure"]
impl crate::Writable for PCMSK1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PCMSK1 to value 0"]
impl crate::Resettable for PCMSK1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
